/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.async;

import com.sun.genericra.inbound.async.EndpointConsumer;
import com.sun.genericra.inbound.async.InboundJmsResourcePool;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.resource.ResourceException;

public class ReconnectHelper
implements ExceptionListener {
    private static Logger _logger = LogUtils.getLogger();
    private InboundJmsResourcePool pool = null;
    private EndpointConsumer consumer = null;
    private int attempts = 0;
    private long interval = 0L;
    private boolean reconnectInitiated = false;

    public ReconnectHelper(InboundJmsResourcePool pool, EndpointConsumer consumer) {
        this.pool = pool;
        this.consumer = consumer;
        this.attempts = consumer.getSpec().getReconnectAttempts();
        this.interval = consumer.getSpec().getReconnectInterval() * 1000;
    }

    public void onException(JMSException exception) {
        if (this.reconnectInitiated || this.consumer.isStopped()) {
            _logger.log(Level.INFO, "Reconnect is in progress");
            return;
        }
        this.reconnectInitiated = true;
        _logger.log(Level.INFO, "Reconnecting now");
        _logger.log(Level.INFO, "Reconnecting now");
        _logger.log(Level.INFO, "Reconnecting now");
        if (this.reestablishPool()) {
            _logger.log(Level.INFO, "Reconnected!!");
        } else {
            _logger.log(Level.SEVERE, "Reconnect failed in pool!!");
        }
    }

    private void createConsumer() throws ResourceException {
        try {
            this.consumer.closeConsumer();
            this.consumer.restart();
        }
        catch (ResourceException re) {
            _logger.log(Level.INFO, "Reconnection failed, Cannot create consumer");
            try {
                this.pool.stop();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Reconnect failed while stopping pool");
            }
            _logger.log(Level.INFO, "Stopping the consumer");
            throw re;
        }
    }

    private boolean reestablishPool() {
        try {
            this.pool.stop();
        }
        catch (JMSException je) {
            _logger.log(Level.SEVERE, "Reconnect failed while stopping pool");
            je.printStackTrace();
            return false;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Reconnect failed while stopping pool " + e);
        }
        boolean result = false;
        for (int i = 0; i < this.attempts; ++i) {
            _logger.log(Level.INFO, "Reconnect attempt->" + i);
            try {
                this.pool.initialize();
                this.pool.releaseAllWaitingThreads();
                this.createConsumer();
                _logger.log(Level.INFO, "Reconnect successful with pool->" + i);
                result = true;
                break;
            }
            catch (ResourceException re) {
                _logger.log(Level.INFO, "Reconnect attempt failed. Now sleeping for" + this.interval);
                try {
                    Thread.sleep(this.interval);
                }
                catch (Exception e) {
                    _logger.info("Thread.sleep exception");
                }
                continue;
            }
        }
        return result;
    }

    public InboundJmsResourcePool getPool() {
        return this.pool;
    }
}

