/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import com.sun.genericra.inbound.AbstractJmsResource;
import com.sun.genericra.inbound.sync.SyncDeliveryHelper;
import com.sun.genericra.inbound.sync.SyncJmsResourcePool;
import com.sun.genericra.inbound.sync.SyncWorker;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.XASession;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class SyncJmsResource
extends AbstractJmsResource {
    private static Logger _logger = LogUtils.getLogger();
    private boolean free;
    private SyncDeliveryHelper helper;
    private Work w;
    private boolean stopWork = false;
    private int sessionid;

    public SyncJmsResource(Session session, SyncJmsResourcePool pool) throws JMSException {
        this(session, pool, null);
    }

    public SyncJmsResource(Session session, SyncJmsResourcePool pool, XAResource xaresource) throws JMSException {
        super(session, pool, xaresource);
    }

    public void setSessionid(int id) {
        this.sessionid = id;
    }

    public int getSessionid() {
        return this.sessionid;
    }

    public MessageConsumer getReceiver() throws JMSException {
        return this.getPool().createMessageConsumer(this.session);
    }

    public void start() throws JMSException {
        try {
            _logger.log(Level.FINER, "Sync Provider is starting the message consumtion #" + this.sessionid);
            this.w = new SyncWorker(this);
            WorkManager wm = this.ra.getWorkManager();
            wm.scheduleWork(this.w);
        }
        catch (WorkException we) {
            throw ExceptionUtils.newJMSException(we);
        }
    }

    public void refreshListener() throws JMSException {
        this.helper = new SyncDeliveryHelper(this, (SyncJmsResourcePool)this.pool);
    }

    public boolean getIsWorkStopped() {
        return this.stopWork;
    }

    public void destroy() {
        block3: {
            if (this.session != null) {
                try {
                    this.stopWork = true;
                    this.w.release();
                    _logger.log(Level.FINE, "Released the Worker the session #" + this.sessionid);
                    this.session.close();
                    _logger.log(Level.FINE, "Closed the session #" + this.sessionid);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
    }

    public SyncDeliveryHelper getDeliveryHelper() {
        return this.helper;
    }

    public XAResource getXAResource() {
        return this.xaresource;
    }

    public Session getSession() {
        _logger.log(Level.FINEST, "Message provider got the session :" + this.session);
        return this.session;
    }

    public XASession getXASession() {
        return (XASession)this.session;
    }

    public void refresh() throws JMSException {
        MessageEndpointFactory mef = this.pool.getConsumer().getMessageEndpointFactory();
        try {
            _logger.log(Level.FINER, "Creating message endpoint #" + this.sessionid + this.xaresource);
            this.endPoint = mef.createEndpoint(this.helper.getXAResource());
            this.endPoint.beforeDelivery(this.ra.getListeningMethod());
            _logger.log(Level.FINE, "Created endpoint  #" + this.sessionid);
        }
        catch (Exception e) {
            e.printStackTrace();
            _logger.log(Level.SEVERE, "Refresh resource failed #" + this.sessionid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEndpoint() {
        try {
            if (this.endPoint != null) {
                this.endPoint.afterDelivery();
                _logger.log(Level.FINE, "After Delivery success in SyncJmsResource");
            }
        }
        catch (Exception re) {
            _logger.log(Level.SEVERE, "After delivery failed in resource #" + this.sessionid + re.getMessage());
        }
        finally {
            this.release();
        }
    }

    public void release() {
        if (this.endPoint != null) {
            try {
                this.endPoint.release();
                _logger.log(Level.FINE, "SyncJmsResource: released endpoint in #" + this.sessionid);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "SyncJmsResource: release endpoint failed #" + this.sessionid);
            }
            this.endPoint = null;
        }
    }
}

