/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import com.sun.genericra.inbound.AbstractJmsResourcePool;
import com.sun.genericra.inbound.sync.SyncConsumer;
import com.sun.genericra.inbound.sync.SyncJmsResource;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;

public class SyncJmsResourcePool
extends AbstractJmsResourcePool {
    private static Logger _logger = LogUtils.getLogger();
    private int sessions;
    private int connections;
    private List mResources;
    private int mSessions = this.consumer.getSpec().getDeliveryConcurrencyMode() == "SERIAL" ? 1 : (this.consumer.getSpec().getDestinationType().equals(Topic.class.getName()) ? 1 : this.consumer.getSpec().getMaxPoolSize());
    private int mBatchSize;
    private boolean mHoldUntilAck;
    private boolean stopped = true;

    public SyncJmsResourcePool(SyncConsumer cons, boolean transacted) {
        super(cons, transacted);
        _logger.log(Level.FINE, "number of sessions specified to be " + this.mSessions);
        this.mBatchSize = this.consumer.getSpec().getBatchSize();
        boolean huaMode = this.consumer.getSpec().getHUAMode();
        if (huaMode) {
            this.mHoldUntilAck = true;
        }
        this.mResources = new ArrayList();
    }

    public int getBatchSize() {
        return this.mBatchSize;
    }

    public boolean getHUAMode() {
        return this.mHoldUntilAck;
    }

    public int getSessions() {
        return this.mSessions;
    }

    public int getMaxSize() {
        return 1;
    }

    public long getMaxWaitTime() {
        return 1L;
    }

    public int getCurrentResources() {
        return 1;
    }

    public int getBusyResources() {
        return 1;
    }

    public int getFreeResources() {
        return 1;
    }

    public int getConnectionsInUse() {
        return 1;
    }

    public int getWaiting() {
        return 1;
    }

    public synchronized void initialize() throws ResourceException {
        try {
            this.sessions = this.consumer.getSpec().getMaxPoolSize();
            if (this.consumer.getSpec().getSupportsXA()) {
                _logger.log(Level.FINE, "Creating CF ");
                XAConnectionFactory xacf = (XAConnectionFactory)this.consumer.getConnectionFactory();
                _logger.log(Level.FINE, "Created CF ");
                _logger.log(Level.FINE, "Creating XA Connection ");
                this.con = this.createXAConnection(xacf);
                String clientID = this.consumer.getSpec().getClientID();
                if (clientID != null && !"".equals(clientID)) {
                    this.con.setClientID(clientID);
                }
                _logger.log(Level.FINE, "DMD connection factory " + this.consumer.getDmdConnectionFactory());
                ConnectionFactory cf = (ConnectionFactory)this.consumer.getDmdConnectionFactory();
                if (this.consumer.getSpec().getSendBadMessagesToDMD()) {
                    this.dmdCon = this.createDmdConnection(cf);
                }
            } else {
                if (!(this.consumer.getConnectionFactory() instanceof ConnectionFactory)) {
                    String msg = this.sm.getString("classtype_not_correct", this.consumer.getConnectionFactory().getClass().getName());
                    throw new ResourceException(msg);
                }
                this.cf = (ConnectionFactory)this.consumer.getConnectionFactory();
                this.con = this.createConnection(this.cf);
                String clientID = this.consumer.getSpec().getClientID();
                if (clientID != null && !"".equals(clientID)) {
                    this.con.setClientID(clientID);
                }
            }
            for (int i = 0; i < this.mSessions; ++i) {
                SyncJmsResource res = this.create();
                res.setSessionid(i);
                this.mResources.add(res);
                res.start();
            }
            this.stopped = false;
        }
        catch (JMSException e) {
            throw ExceptionUtils.newResourceException(e);
        }
    }

    public SyncJmsResource create() throws JMSException {
        _logger.log(Level.FINER, "Creating the Session");
        Session sess = null;
        XAResource xar = null;
        if (this.transacted) {
            sess = this.createXASession((XAConnection)this.con);
            xar = this.getXAResource((XASession)sess);
            _logger.log(Level.FINE, "Created new XA Session");
        } else {
            sess = this.createSession(this.con);
            _logger.log(Level.FINE, "Created new Session");
        }
        return new SyncJmsResource(sess, this, xar);
    }

    public void releaseAllResources() {
        Iterator it = this.mResources.iterator();
        while (it.hasNext()) {
            SyncJmsResource obj = (SyncJmsResource)it.next();
            try {
                obj.destroy();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Cannot destroy resource " + obj.toString());
            }
        }
    }

    public void stop() throws JMSException {
        this.stopped = true;
        this.releaseAllResources();
        if (this.dmdCon != null) {
            this.dmdCon.close();
        }
    }

    public void destroy() throws JMSException {
        this.stop();
    }
}

