/*
 * Copyright (c) 2007, 2019 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.gmbal;

import java.util.Map;
import org.glassfish.external.amx.AMX;


/** Base interface supported by all AMXMBeanInterface MBeans.  All MBeans generated by
 * gmbal comply with this interface, which means that the attributes and
 * operations defined in this Java interface all appear in each
 * MBean generated by calling ManagedObjectManager.register.
 *
 * @author LLoyd Chambers
 * @author Ken Cavanaugh
 *
 */
@ManagedObject
@Description( "Base interface for any MBean that works in the AMX framework" )
public interface AMXMBeanInterface {
    /** Get all metadata about this MBean.
     * @return The descriptor, which will be a ModelMBeanInfoSupport instance.
     */
    public Map<String,?> getMeta();

    /** Usually the same as the ObjectName 'name' property, but can differ
        if the actual name contains characters that must be escaped for an ObjectName and/or
        if the MBean has a mutable name attribute.
       The type property can be obtained from the ObjectName */
    @ManagedAttribute( id=AMX.ATTR_NAME )
    @Description( "Return the name of this MBean.")
    public String getName();

    /** "go up one level": the MBean containing this one, can be null for root
     * @return The container of this MBean (null if already at root).
     */
    @ManagedAttribute( id=AMX.ATTR_PARENT )
    @Description( "The container that contains this MBean" )
    public AMXMBeanInterface getParent();

    /** Containment hierarchy:
        Get all AMXMBeanInterface contained by this one, in no particular order.
        Valid only if isContainer().
     * Note that using an array sidesteps Map/Set/OpenType issues
     * @return All children of this AMXMBeanInterface MBean.
     */
    @ManagedAttribute( id=AMX.ATTR_CHILDREN )
    @Description( "All children of this AMX MBean")
    public AMXMBeanInterface[] getChildren();
}
