/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.typelib;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.glassfish.gmbal.generic.Algorithms;
import org.glassfish.gmbal.generic.Display;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.generic.UnaryFunction;
import org.glassfish.gmbal.typelib.DeclarationFactory;
import org.glassfish.gmbal.typelib.EvaluatedArrayType;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;

public class TypeEvaluator {
    private static boolean DEBUG = false;
    private static boolean DEBUG_EVALUATE = false;
    private static Map<EvalMapKey, EvaluatedClassDeclaration> evalClassMap = new WeakHashMap<EvalMapKey, EvaluatedClassDeclaration>();

    public static void dumpEvalClassMap() {
        System.out.println("TypeEvaluator: dumping eval class map");
        int numSystem = 0;
        int total = 0;
        for (Map.Entry<EvalMapKey, EvaluatedClassDeclaration> entry : evalClassMap.entrySet()) {
            System.out.println("\tKey:" + entry.getKey() + "=>\n");
            System.out.println("\t\t" + entry.getValue());
            String name = ((Class)entry.getKey().first()).getName();
            if (!name.startsWith("org.glassfish.gmbal")) {
                ++numSystem;
            }
            ++total;
        }
        System.out.printf("\nEvalClassMap contains %d entries, %d of which are system classes\n", total, numSystem);
    }

    public static synchronized EvaluatedType getEvaluatedType(Type jtype) {
        TypeEvaluationVisitor visitor = new TypeEvaluationVisitor();
        EvaluatedType etype = visitor.evaluateType(jtype);
        return etype;
    }

    public static class IdentitySetImpl {
        private IdentityHashMap<Object, Object> map = new IdentityHashMap();

        public boolean contains(Object arg) {
            return this.map.keySet().contains(arg);
        }

        public void add(Object arg) {
            this.map.put(arg, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeEvaluationVisitor {
        private final Display<String, EvaluatedType> display = new Display();
        private final DprintUtil dputil = TypeEvaluator.access$000() || TypeEvaluator.access$100() ? new DprintUtil(this.getClass()) : null;
        private final Map<Class<?>, EvaluatedClassDeclaration> partialDefinitions = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType lookup(TypeVariable tvar) {
            if (DEBUG) {
                this.dputil.enter("lookup", "tvar=", tvar);
            }
            try {
                EvaluatedType result = this.display.lookup(tvar.getName());
                if (result == null) {
                    Type[] bounds;
                    if (DEBUG) {
                        this.dputil.info("tvar not found in display");
                    }
                    if ((bounds = tvar.getBounds()).length > 0) {
                        if (bounds.length > 1) {
                            throw new UnsupportedOperationException("Not supported");
                        }
                        result = this.evaluateType(bounds[0]);
                    } else {
                        result = EvaluatedType.EOBJECT;
                    }
                }
                if (DEBUG) {
                    this.dputil.info("result=" + result);
                }
                EvaluatedType evaluatedType = result;
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        public EvaluatedType evaluateType(Object type) {
            if (DEBUG || DEBUG_EVALUATE) {
                this.dputil.enter("evaluateType", "type=", type);
            }
            try {
                if (type == null) {
                    EvaluatedType evaluatedType = null;
                    return evaluatedType;
                }
                if (type instanceof Class) {
                    Class cls = (Class)type;
                    EvaluatedType evaluatedType = this.visitClassDeclaration(cls);
                    return evaluatedType;
                }
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    EvaluatedType evaluatedType = this.visitParameterizedType(pt);
                    return evaluatedType;
                }
                if (type instanceof TypeVariable) {
                    TypeVariable tvar = (TypeVariable)type;
                    EvaluatedType evaluatedType = this.visitTypeVariable(tvar);
                    return evaluatedType;
                }
                if (type instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)type;
                    EvaluatedType evaluatedType = this.visitGenericArrayType(gat);
                    return evaluatedType;
                }
                if (type instanceof WildcardType) {
                    WildcardType wt = (WildcardType)type;
                    EvaluatedType evaluatedType = this.visitWildcardType(wt);
                    return evaluatedType;
                }
                if (type instanceof Method) {
                    Method method = (Method)type;
                    EvaluatedMethodDeclaration evaluatedMethodDeclaration = this.visitMethodDeclaration(method);
                    return evaluatedMethodDeclaration;
                }
                throw new IllegalArgumentException("Unknown type???" + type);
            }
            finally {
                if (DEBUG || DEBUG_EVALUATE) {
                    this.dputil.exit();
                }
            }
        }

        private OrderedResult<String, EvaluatedType> getBindings(Class decl) {
            OrderedResult<String, EvaluatedType> result = new OrderedResult<String, EvaluatedType>();
            for (TypeVariable tv : decl.getTypeParameters()) {
                EvaluatedType res = this.lookup(tv);
                result.add(tv.getName(), res);
            }
            return result;
        }

        private EvaluatedType getCorrectDeclaration(OrderedResult<String, EvaluatedType> bindings, Class decl, EvaluatedClassDeclaration newDecl) {
            EvalMapKey key = new EvalMapKey(decl, bindings.getList());
            newDecl.instantiations(bindings.getList());
            EvaluatedType result = (EvaluatedType)evalClassMap.get(key);
            if (result == null) {
                evalClassMap.put(key, newDecl);
                this.processClass(newDecl, bindings.getMap(), decl);
                result = newDecl;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitClassDeclaration(Class decl) {
            if (DEBUG) {
                this.dputil.enter("visitClassDeclaration", "decl=", decl);
            }
            try {
                EvaluatedType result = this.partialDefinitions.get(decl);
                if (result == null) {
                    EvaluatedClassDeclaration newDecl = DeclarationFactory.ecdecl(decl.getModifiers(), decl.getName(), decl);
                    this.partialDefinitions.put(decl, newDecl);
                    try {
                        OrderedResult<String, EvaluatedType> bindings = this.getBindings(decl);
                        result = this.getCorrectDeclaration(bindings, decl, newDecl);
                    }
                    finally {
                        this.partialDefinitions.remove(decl);
                    }
                } else if (DEBUG) {
                    this.dputil.info("found result=" + result);
                }
                EvaluatedType evaluatedType = result;
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Type> getInheritance(Class cls) {
            if (DEBUG) {
                this.dputil.enter("getInheritance", "cls=", cls);
            }
            try {
                ArrayList<Type> result = new ArrayList<Type>();
                result.add(cls.getGenericSuperclass());
                result.addAll(Arrays.asList(cls.getGenericInterfaces()));
                if (DEBUG) {
                    this.dputil.info("result=" + result);
                }
                ArrayList<Type> arrayList = result;
                return arrayList;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processClass(EvaluatedClassDeclaration newDecl, Map<String, EvaluatedType> bindings, Class decl) {
            if (DEBUG) {
                this.dputil.enter("processClass", "bindings=", bindings, "decl=", decl);
            }
            this.display.enterScope();
            this.display.bind(bindings);
            try {
                List<EvaluatedClassDeclaration> inheritance = Algorithms.map(this.getInheritance(decl), new UnaryFunction<Type, EvaluatedClassDeclaration>(){

                    @Override
                    public EvaluatedClassDeclaration evaluate(Type pt) {
                        return (EvaluatedClassDeclaration)TypeEvaluationVisitor.this.evaluateType(pt);
                    }
                });
                if (DEBUG) {
                    this.dputil.info("inheritance=" + inheritance);
                }
                newDecl.inheritance(inheritance);
                if (DEBUG) {
                    this.dputil.info("newDecl=" + newDecl);
                }
                List<EvaluatedMethodDeclaration> newMethods = Algorithms.map(Arrays.asList(decl.getDeclaredMethods()), new UnaryFunction<Method, EvaluatedMethodDeclaration>(){

                    @Override
                    public EvaluatedMethodDeclaration evaluate(Method md) {
                        return TypeEvaluationVisitor.this.visitMethodDeclaration(md);
                    }
                });
                newDecl.methods(newMethods);
            }
            finally {
                this.display.exitScope();
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedMethodDeclaration visitMethodDeclaration(Method decl) {
            if (DEBUG) {
                this.dputil.enter("visitMethodDeclaration", "decl=", decl);
            }
            try {
                List<EvaluatedType> eptypes = Algorithms.map(Arrays.asList(decl.getGenericParameterTypes()), new UnaryFunction<Type, EvaluatedType>(){

                    @Override
                    public EvaluatedType evaluate(Type type) {
                        return TypeEvaluationVisitor.this.evaluateType(type);
                    }
                });
                if (DEBUG) {
                    this.dputil.info("eptypes=" + eptypes);
                }
                if (decl.getName().equals("getThing") && DEBUG) {
                    this.dputil.info("processing getThing method from test");
                }
                EvaluatedMethodDeclaration result = DeclarationFactory.emdecl(decl.getModifiers(), this.evaluateType(decl.getGenericReturnType()), decl.getName(), eptypes, decl);
                if (DEBUG) {
                    this.dputil.info("result=" + result);
                }
                EvaluatedMethodDeclaration evaluatedMethodDeclaration = result;
                return evaluatedMethodDeclaration;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitTypeVariable(TypeVariable tvar) {
            if (DEBUG) {
                this.dputil.enter("visitTypeVariable", new Object[0]);
            }
            try {
                EvaluatedType evaluatedType = this.lookup(tvar);
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitGenericArrayType(GenericArrayType at) {
            if (DEBUG) {
                this.dputil.enter("visitTypeVariable", new Object[0]);
            }
            try {
                EvaluatedArrayType evaluatedArrayType = DeclarationFactory.egat(this.evaluateType(at.getGenericComponentType()));
                return evaluatedArrayType;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitWildcardType(WildcardType wt) {
            if (DEBUG) {
                this.dputil.enter("visitTypeVariable", new Object[0]);
            }
            try {
                EvaluatedType result;
                List<Type> ub = Arrays.asList(wt.getUpperBounds());
                if (ub.size() > 0) {
                    if (ub.size() > 1) {
                        throw new UnsupportedOperationException("Not supported");
                    }
                    result = this.evaluateType(ub.get(0));
                } else {
                    result = EvaluatedType.EOBJECT;
                }
                EvaluatedClassDeclaration evaluatedClassDeclaration = result;
                return evaluatedClassDeclaration;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        private OrderedResult<String, EvaluatedType> getBindings(ParameterizedType pt) {
            OrderedResult<String, EvaluatedType> result = new OrderedResult<String, EvaluatedType>();
            Iterator<Type> types = Arrays.asList(pt.getActualTypeArguments()).iterator();
            Iterator tvars = Arrays.asList(((Class)pt.getRawType()).getTypeParameters()).iterator();
            while (types.hasNext() && tvars.hasNext()) {
                Type type = types.next();
                TypeVariable tvar = tvars.next();
                result.add(tvar.getName(), this.evaluateType(type));
            }
            if (types.hasNext() != tvars.hasNext()) {
                throw new IllegalArgumentException("Type list and TypeVariable list are not the same length");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitParameterizedType(ParameterizedType pt) {
            if (DEBUG) {
                this.dputil.enter("visitParameterizedType", "pt=", pt);
            }
            Class decl = (Class)pt.getRawType();
            try {
                EvaluatedType result = this.partialDefinitions.get(decl);
                if (result == null) {
                    EvaluatedClassDeclaration newDecl = DeclarationFactory.ecdecl(decl.getModifiers(), decl.getName(), decl);
                    this.partialDefinitions.put(decl, newDecl);
                    try {
                        OrderedResult<String, EvaluatedType> bindings = this.getBindings(pt);
                        result = this.getCorrectDeclaration(bindings, decl, newDecl);
                    }
                    finally {
                        this.partialDefinitions.remove(decl);
                    }
                }
                EvaluatedType evaluatedType = result;
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class OrderedResult<K, V> {
            private List<V> list = new ArrayList<V>();
            private Map<K, V> map = new HashMap();

            public List<V> getList() {
                return this.list;
            }

            public Map<K, V> getMap() {
                return this.map;
            }

            public void add(K key, V value) {
                this.list.add(value);
                this.map.put(key, value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EvalMapKey
    extends Pair<Class<?>, List<EvaluatedType>> {
        public EvalMapKey(Class<?> cls, List<EvaluatedType> decls) {
            super(cls, decls);
        }
    }
}

