/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.generic;

import java.util.Stack;

public class DprintUtil {
    private static final boolean USE_LOGGER = false;
    private String sourceClassName;
    private String loggerName;
    private ThreadLocal<Stack<String>> currentMethod = new ThreadLocal<Stack<String>>(){

        @Override
        public Stack<String> initialValue() {
            return new Stack<String>();
        }
    };

    public DprintUtil(Class selfClass) {
        this.sourceClassName = DprintUtil.compressClassName(selfClass.getName());
        this.loggerName = selfClass.getPackage().getName();
    }

    private static String compressClassName(String name) {
        String prefix = "org.glassfish.gmbal.";
        if (name.startsWith(prefix)) {
            return "(GMBAL)." + name.substring(prefix.length());
        }
        return name;
    }

    private synchronized void dprint(String msg) {
        String prefix = "(" + Thread.currentThread().getName() + "): ";
        System.out.println(prefix + this.sourceClassName + msg);
    }

    private synchronized void dprint(String msg, Throwable exc) {
        String prefix = "(" + Thread.currentThread().getName() + "): ";
        System.out.println(prefix + this.sourceClassName + msg + ": " + exc);
        exc.printStackTrace();
    }

    private String makeString(Object ... args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (Object obj : args) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            if (obj == null) {
                sb.append("<NULL>");
                continue;
            }
            sb.append(obj.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public void enter(String mname, Object ... args) {
        this.currentMethod.get().push(mname);
        String str = this.makeString(args);
        this.dprint("." + mname + "->" + str);
    }

    public void info(Object ... args) {
        String mname = this.currentMethod.get().peek();
        String str = this.makeString(args);
        this.dprint("." + mname + "::" + str);
    }

    public void exception(String msg, Throwable exc) {
        String mname = this.currentMethod.get().peek();
        String str = this.makeString("Exception: ", msg, exc);
        this.dprint("." + mname + "::" + str, exc);
    }

    public void exit() {
        String mname = this.currentMethod.get().peek();
        this.dprint("." + mname + "<-");
        this.currentMethod.get().pop();
    }

    public void exit(Object retVal) {
        String mname = this.currentMethod.get().peek();
        this.dprint("." + mname + "<-(" + retVal + ")");
        this.currentMethod.get().pop();
    }
}

