/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;
import org.glassfish.gmbal.AMX;
import org.glassfish.gmbal.GmbalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXClient
implements AMX {
    private MBeanServerConnection server;
    private ObjectName oname;

    private <T> T fetchAttribute(String name, Class<T> type) {
        try {
            return type.cast(this.server.getAttribute(this.oname, name));
        }
        catch (JMException exc) {
            throw new GmbalException("Exception in fetchAttribute", (Throwable)exc);
        }
        catch (IOException exc) {
            throw new GmbalException("Exception in fetchAttribute", (Throwable)exc);
        }
    }

    public AMXClient(MBeanServerConnection server, ObjectName oname) {
        this.server = server;
        this.oname = oname;
    }

    private AMXClient makeAMX(ObjectName on) {
        return new AMXClient(this.server, on);
    }

    public String getName() {
        return this.fetchAttribute("getName", String.class);
    }

    public Map<String, ?> getMeta() {
        try {
            ModelMBeanInfo mbi = (ModelMBeanInfo)((Object)this.server.getMBeanInfo(this.oname));
            Descriptor desc = mbi.getMBeanDescriptor();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String str : desc.getFieldNames()) {
                result.put(str, desc.getFieldValue(str));
            }
            return result;
        }
        catch (MBeanException ex) {
            throw new GmbalException("Exception in getMeta", (Throwable)ex);
        }
        catch (RuntimeOperationsException ex) {
            throw new GmbalException("Exception in getMeta", (Throwable)ex);
        }
        catch (InstanceNotFoundException ex) {
            throw new GmbalException("Exception in getMeta", (Throwable)ex);
        }
        catch (IntrospectionException ex) {
            throw new GmbalException("Exception in getMeta", (Throwable)ex);
        }
        catch (ReflectionException ex) {
            throw new GmbalException("Exception in getMeta", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GmbalException("Exception in getMeta", (Throwable)ex);
        }
    }

    public AMX getParent() {
        ObjectName res = this.fetchAttribute("getContainer", ObjectName.class);
        return this.makeAMX(res);
    }

    public AMX[] getChildren() {
        ObjectName[] onames = this.fetchAttribute("getContained", ObjectName[].class);
        return this.makeAMXArray(onames);
    }

    private AMX[] makeAMXArray(ObjectName[] onames) {
        AMX[] result = new AMX[onames.length];
        int ctr = 0;
        for (ObjectName on : onames) {
            result[ctr++] = this.makeAMX(on);
        }
        return result;
    }

    public Object getAttribute(String attribute) {
        try {
            return this.server.getAttribute(this.oname, attribute);
        }
        catch (MBeanException ex) {
            throw new GmbalException("Exception in getAttribute", (Throwable)ex);
        }
        catch (AttributeNotFoundException ex) {
            throw new GmbalException("Exception in getAttribute", (Throwable)ex);
        }
        catch (ReflectionException ex) {
            throw new GmbalException("Exception in getAttribute", (Throwable)ex);
        }
        catch (InstanceNotFoundException ex) {
            throw new GmbalException("Exception in getAttribute", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GmbalException("Exception in getAttribute", (Throwable)ex);
        }
    }

    public void setAttribute(Attribute attribute) {
        try {
            this.server.setAttribute(this.oname, attribute);
        }
        catch (InstanceNotFoundException ex) {
            throw new GmbalException("Exception in setAttribute", (Throwable)ex);
        }
        catch (AttributeNotFoundException ex) {
            throw new GmbalException("Exception in setAttribute", (Throwable)ex);
        }
        catch (InvalidAttributeValueException ex) {
            throw new GmbalException("Exception in setAttribute", (Throwable)ex);
        }
        catch (MBeanException ex) {
            throw new GmbalException("Exception in setAttribute", (Throwable)ex);
        }
        catch (ReflectionException ex) {
            throw new GmbalException("Exception in setAttribute", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GmbalException("Exception in setAttribute", (Throwable)ex);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.server.getAttributes(this.oname, attributes);
        }
        catch (InstanceNotFoundException ex) {
            throw new GmbalException("Exception in getAttributes", (Throwable)ex);
        }
        catch (ReflectionException ex) {
            throw new GmbalException("Exception in getAttributes", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GmbalException("Exception in getAttributes", (Throwable)ex);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.server.setAttributes(this.oname, attributes);
        }
        catch (InstanceNotFoundException ex) {
            throw new GmbalException("Exception in setAttributes", (Throwable)ex);
        }
        catch (ReflectionException ex) {
            throw new GmbalException("Exception in setAttributes", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GmbalException("Exception in setAttributes", (Throwable)ex);
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            return this.server.invoke(this.oname, actionName, params, signature);
        }
        catch (InstanceNotFoundException ex) {
            throw new GmbalException("Exception in invoke", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GmbalException("Exception in invoke", (Throwable)ex);
        }
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return this.server.getMBeanInfo(this.oname);
        }
        catch (InstanceNotFoundException ex) {
            throw new GmbalException("Exception in invoke", (Throwable)ex);
        }
        catch (IntrospectionException ex) {
            throw new GmbalException("Exception in invoke", (Throwable)ex);
        }
        catch (ReflectionException ex) {
            throw new GmbalException("Exception in invoke", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GmbalException("Exception in invoke", (Throwable)ex);
        }
    }
}

