/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.List;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.DumpIgnore;
import org.glassfish.gmbal.generic.DumpToString;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDescriptor {
    @DumpToString
    private EvaluatedMethodDeclaration _method;
    @DumpToString
    private EvaluatedFieldDeclaration _field;
    private String _id;
    private String _description;
    private AttributeType _atype;
    @DumpToString
    private EvaluatedType _type;
    private TypeConverter _tc;
    @DumpIgnore
    private DprintUtil dputil = new DprintUtil(this.getClass());
    private static final Permission accessControlPermission = new ReflectPermission("suppressAccessChecks");

    private AttributeDescriptor(ManagedObjectManagerInternal mom, final EvaluatedFieldDeclaration field, String id, String description, EvaluatedType type) {
        SecurityManager sman = System.getSecurityManager();
        if (sman != null) {
            sman.checkPermission(accessControlPermission);
        }
        this._method = null;
        this._field = AccessController.doPrivileged(new PrivilegedAction<EvaluatedFieldDeclaration>(){

            @Override
            public EvaluatedFieldDeclaration run() {
                field.field().setAccessible(true);
                return field;
            }
        });
        this._id = id;
        this._description = description;
        this._atype = AttributeType.GETTER;
        this._type = type;
        this._tc = mom.getTypeConverter(type);
    }

    private AttributeDescriptor(ManagedObjectManagerInternal mom, final EvaluatedMethodDeclaration method, String id, String description, AttributeType atype, EvaluatedType type) {
        SecurityManager sman = System.getSecurityManager();
        if (sman != null) {
            sman.checkPermission(accessControlPermission);
        }
        this._field = null;
        this._method = AccessController.doPrivileged(new PrivilegedAction<EvaluatedMethodDeclaration>(){

            @Override
            public EvaluatedMethodDeclaration run() {
                method.method().setAccessible(true);
                return method;
            }
        });
        this._id = id;
        this._description = description;
        this._atype = atype;
        this._type = type;
        this._tc = mom.getTypeConverter(type);
    }

    public final Field field() {
        return this._field.field();
    }

    public final Method method() {
        return this._method.method();
    }

    public final String id() {
        return this._id;
    }

    public final String description() {
        return this._description;
    }

    public final AttributeType atype() {
        return this._atype;
    }

    public final EvaluatedType type() {
        return this._type;
    }

    public final TypeConverter tc() {
        return this._tc;
    }

    public boolean isApplicable(Object obj) {
        return this._method.method().getDeclaringClass().isInstance(obj);
    }

    private void checkType(AttributeType at) {
        if (at != this._atype) {
            throw Exceptions.self.excForCheckType(at);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(FacetAccessor fa, boolean debug) throws MBeanException, ReflectionException {
        if (debug) {
            this.dputil.enter("get", "fa=", fa);
        }
        this.checkType(AttributeType.GETTER);
        Object result = null;
        try {
            if (this._method != null) {
                result = this._tc.toManagedEntity(fa.invoke(this._method.method(), debug, new Object[0]));
            } else {
                if (this._field == null) throw new RuntimeException("both _field and _method are null!");
                result = this._tc.toManagedEntity(fa.get(this._field.field(), debug));
            }
            if (!debug) return result;
        }
        catch (RuntimeException exc) {
            try {
                if (!debug) throw exc;
                this.dputil.exception("Error:", exc);
                throw exc;
            }
            catch (Throwable throwable) {
                if (!debug) throw throwable;
                this.dputil.exit(result);
                throw throwable;
            }
        }
        this.dputil.exit(result);
        return result;
    }

    public void set(FacetAccessor target, Object value, boolean debug) throws MBeanException, ReflectionException {
        this.checkType(AttributeType.SETTER);
        if (debug) {
            this.dputil.enter("set", "target=", target, "value=", value);
        }
        try {
            target.invoke(this._method.method(), debug, this._tc.fromManagedEntity(value));
        }
        catch (RuntimeException exc) {
            if (debug) {
                this.dputil.exception("Error:", exc);
            }
            throw exc;
        }
        finally {
            if (debug) {
                this.dputil.exit();
            }
        }
    }

    private static boolean startsWithNotEquals(String str, String prefix) {
        return str.startsWith(prefix) && !str.equals(prefix);
    }

    private static String stripPrefix(String str, String prefix) {
        return str.substring(prefix.length());
    }

    private static String lowerInitialCharacter(String arg) {
        if (arg == null || arg.length() == 0) {
            return arg;
        }
        char initChar = Character.toLowerCase(arg.charAt(0));
        String rest = arg.substring(1);
        return initChar + rest;
    }

    private static String getDerivedId(String methodName, Pair<AttributeType, EvaluatedType> ainfo, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        boolean needLowerCase;
        String result = methodName;
        boolean bl = needLowerCase = adt == ManagedObjectManagerInternal.AttributeDescriptorType.COMPOSITE_DATA_ATTR;
        if (ainfo.first() == AttributeType.GETTER) {
            if (AttributeDescriptor.startsWithNotEquals(methodName, "get")) {
                result = AttributeDescriptor.stripPrefix(methodName, "get");
                if (needLowerCase) {
                    result = AttributeDescriptor.lowerInitialCharacter(result);
                }
            } else if (ainfo.second().equals(EvaluatedType.EBOOLEAN) && AttributeDescriptor.startsWithNotEquals(methodName, "is")) {
                result = AttributeDescriptor.stripPrefix(methodName, "is");
                if (needLowerCase) {
                    result = AttributeDescriptor.lowerInitialCharacter(result);
                }
            }
        } else if (AttributeDescriptor.startsWithNotEquals(methodName, "set")) {
            result = AttributeDescriptor.stripPrefix(methodName, "set");
            if (needLowerCase) {
                result = AttributeDescriptor.lowerInitialCharacter(result);
            }
        }
        return result;
    }

    private static Pair<AttributeType, EvaluatedType> getTypeInfo(EvaluatedFieldDeclaration field) {
        EvaluatedType ftype = field.fieldType();
        AttributeType atype = AttributeType.GETTER;
        return new Pair<AttributeType, EvaluatedType>(atype, ftype);
    }

    private static Pair<AttributeType, EvaluatedType> getTypeInfo(EvaluatedMethodDeclaration method) {
        EvaluatedType attrType;
        AttributeType atype;
        EvaluatedType rtype = method.returnType();
        List<EvaluatedType> atypes = method.parameterTypes();
        if (rtype.equals(EvaluatedType.EVOID)) {
            if (atypes.size() != 1) {
                return null;
            }
            atype = AttributeType.SETTER;
            attrType = atypes.get(0);
        } else {
            if (atypes.size() != 0) {
                return null;
            }
            atype = AttributeType.GETTER;
            attrType = rtype;
        }
        return new Pair<AttributeType, EvaluatedType>(atype, attrType);
    }

    private static boolean empty(String arg) {
        return arg == null || arg.length() == 0;
    }

    public static AttributeDescriptor makeFromInherited(ManagedObjectManagerInternal mom, EvaluatedMethodDeclaration method, String id, String methodName, String description, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        if (AttributeDescriptor.empty(methodName) && AttributeDescriptor.empty(id)) {
            throw Exceptions.self.excForMakeFromInherited();
        }
        Pair<AttributeType, EvaluatedType> ainfo = AttributeDescriptor.getTypeInfo(method);
        if (ainfo == null) {
            return null;
        }
        String derivedId = AttributeDescriptor.getDerivedId(method.name(), ainfo, adt);
        if (AttributeDescriptor.empty(methodName) ? !derivedId.equals(id) : !methodName.equals(method.name())) {
            return null;
        }
        String actualId = AttributeDescriptor.empty(id) ? derivedId : id;
        return new AttributeDescriptor(mom, method, actualId, description, ainfo.first(), ainfo.second());
    }

    public static AttributeDescriptor makeFromAnnotated(ManagedObjectManagerInternal mom, EvaluatedFieldDeclaration f, String extId, String description, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        Pair<AttributeType, EvaluatedType> ainfo = AttributeDescriptor.getTypeInfo(f);
        String actualId = AttributeDescriptor.empty(extId) ? AttributeDescriptor.getDerivedId(f.name(), ainfo, adt) : extId;
        return new AttributeDescriptor(mom, f, actualId, description, ainfo.second());
    }

    public static AttributeDescriptor makeFromAnnotated(ManagedObjectManagerInternal mom, EvaluatedMethodDeclaration m, String extId, String description, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        Pair<AttributeType, EvaluatedType> ainfo = AttributeDescriptor.getTypeInfo(m);
        if (ainfo == null) {
            throw Exceptions.self.excForMakeFromAnnotated(m);
        }
        String actualId = AttributeDescriptor.empty(extId) ? AttributeDescriptor.getDerivedId(m.name(), ainfo, adt) : extId;
        return new AttributeDescriptor(mom, m, actualId, description, ainfo.first(), ainfo.second());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeType {
        SETTER,
        GETTER;

    }
}

