/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.LinkedHashSet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.MBeanImpl;

public class JMXRegistrationManager {
    private boolean isSuspended = false;
    private LinkedHashSet<MBeanImpl> deferredRegistrations = new LinkedHashSet();

    public synchronized void suspendRegistration() {
        this.isSuspended = true;
    }

    public synchronized void resumeRegistration() {
        this.isSuspended = false;
        for (MBeanImpl mb : this.deferredRegistrations) {
            try {
                mb.register();
            }
            catch (JMException ex) {
                Exceptions.self.deferredRegistrationException(ex, mb);
            }
        }
        this.deferredRegistrations.clear();
    }

    public synchronized void register(MBeanImpl mb) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.isSuspended) {
            this.deferredRegistrations.add(mb);
        } else {
            mb.register();
        }
    }

    public synchronized void unregister(MBeanImpl mb) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.isSuspended) {
            this.deferredRegistrations.remove(mb);
        }
        mb.unregister();
    }
}

