/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.gmbal.NameValue;
import org.glassfish.gmbal.ParameterNames;
import org.glassfish.gmbal.generic.BinaryFunction;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.DumpIgnore;
import org.glassfish.gmbal.generic.DumpToString;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.impl.AttributeDescriptor;
import org.glassfish.gmbal.impl.DescriptorIntrospector;
import org.glassfish.gmbal.impl.DescriptorUtility;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.typelib.EvaluatedClassAnalyzer;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanSkeleton {
    private Descriptor descriptor;
    private final String type;
    private AMXMetadata mbeanType;
    @DumpToString
    private final AtomicLong sequenceNumber;
    private final ModelMBeanInfoSupport mbInfo;
    @DumpToString
    private final ManagedObjectManagerInternal mom;
    @DumpIgnore
    private final DprintUtil dputil = new DprintUtil(this.getClass());
    private final Map<String, AttributeDescriptor> setters;
    private final Map<String, AttributeDescriptor> getters;
    private AttributeDescriptor nameAttributeDescriptor;
    private final Map<String, Map<List<String>, Operation>> operations;
    private final List<ModelMBeanAttributeInfo> mbeanAttributeInfoList;
    private final List<ModelMBeanOperationInfo> mbeanOperationInfoList;
    private static final Permission accessControlPermission = new ReflectPermission("suppressAccessChecks");
    private static AMXMetadata defaultMBeanType = DefaultMBeanTypeHolder.class.getAnnotation(AMXMetadata.class);

    private <K, L, V> void addToCompoundMap(Map<K, Map<L, V>> source, Map<K, Map<L, V>> dest) {
        for (Map.Entry<K, Map<L, V>> entry : source.entrySet()) {
            Map<L, V> map = entry.getValue();
            if (map == null) {
                map = new HashMap<L, V>();
                dest.put(entry.getKey(), map);
            }
            map.putAll(source.get(entry.getKey()));
        }
    }

    private MBeanSkeleton(MBeanSkeleton first, MBeanSkeleton second) {
        this.mom = first.mom;
        this.type = first.type;
        this.sequenceNumber = new AtomicLong();
        this.setters = new HashMap<String, AttributeDescriptor>();
        this.setters.putAll(second.setters);
        this.setters.putAll(first.setters);
        this.getters = new HashMap<String, AttributeDescriptor>();
        this.getters.putAll(second.getters);
        this.getters.putAll(first.getters);
        this.operations = new HashMap<String, Map<List<String>, Operation>>();
        this.addToCompoundMap(second.operations, this.operations);
        this.addToCompoundMap(first.operations, this.operations);
        this.mbeanAttributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
        this.mbeanAttributeInfoList.addAll(second.mbeanAttributeInfoList);
        this.mbeanAttributeInfoList.addAll(first.mbeanAttributeInfoList);
        this.mbeanOperationInfoList = new ArrayList<ModelMBeanOperationInfo>();
        this.mbeanOperationInfoList.addAll(second.mbeanOperationInfoList);
        this.mbeanOperationInfoList.addAll(first.mbeanOperationInfoList);
        this.descriptor = DescriptorUtility.union(first.descriptor, second.descriptor);
        this.mbInfo = this.makeMbInfo(first.mbInfo.getDescription());
    }

    private ModelMBeanInfoSupport makeMbInfo(String description) {
        ModelMBeanAttributeInfo[] attrInfos = this.mbeanAttributeInfoList.toArray(new ModelMBeanAttributeInfo[this.mbeanAttributeInfoList.size()]);
        ModelMBeanOperationInfo[] operInfos = this.mbeanOperationInfoList.toArray(new ModelMBeanOperationInfo[this.mbeanOperationInfoList.size()]);
        return new ModelMBeanInfoSupport(this.type, description, attrInfos, null, operInfos, null, this.descriptor);
    }

    public MBeanSkeleton compose(MBeanSkeleton skel) {
        return new MBeanSkeleton(skel, this);
    }

    Descriptor makeValidDescriptor(Descriptor desc, DescriptorType dtype, String dname) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] names = desc.getFieldNames();
        Object[] values = desc.getFieldValues(null);
        for (int ctr = 0; ctr < names.length; ++ctr) {
            map.put(names[ctr], values[ctr]);
        }
        map.put("descriptorType", dtype.toString());
        if (dtype == DescriptorType.operation) {
            map.put("role", "operation");
            map.put("targetType", "ObjectReference");
        } else if (dtype == DescriptorType.mbean) {
            map.put("persistPolicy", "never");
            map.put("log", "F");
            map.put("visibility", "1");
        }
        map.put("name", dname);
        map.put("displayName", dname);
        return DescriptorUtility.makeDescriptor(map);
    }

    public String toString() {
        return "DynamicMBeanSkeleton[type=" + this.type + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttribute(AttributeDescriptor getter, AttributeDescriptor setter) {
        if (this.mom.registrationFineDebug()) {
            this.dputil.enter("processAttribute", "getter=", getter, "setter=", setter);
        }
        try {
            if (setter == null && getter == null) {
                throw Exceptions.self.notBothNull();
            }
            if (setter != null && getter != null && !setter.type().equals(getter.type())) {
                throw Exceptions.self.typesMustMatch();
            }
            AttributeDescriptor nonNullDescriptor = getter != null ? getter : setter;
            String name = nonNullDescriptor.id();
            String description = nonNullDescriptor.description();
            Descriptor desc = DescriptorUtility.EMPTY_DESCRIPTOR;
            if (getter != null) {
                desc = DescriptorUtility.union(desc, DescriptorIntrospector.descriptorForElement(getter.accessible()));
            }
            if (setter != null) {
                desc = DescriptorUtility.union(desc, DescriptorIntrospector.descriptorForElement(setter.accessible()));
            }
            desc = this.makeValidDescriptor(desc, DescriptorType.attribute, name);
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("name=", name, "description=", description, "desc=", desc);
            }
            TypeConverter tc = this.mom.getTypeConverter(nonNullDescriptor.type());
            ModelMBeanAttributeInfo ainfo = new ModelMBeanAttributeInfo(name, description, tc.getManagedType().toString(), getter != null, setter != null, false, desc);
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("ainfo=", ainfo);
            }
            this.mbeanAttributeInfoList.add(ainfo);
        }
        finally {
            if (this.mom.registrationFineDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeFields(EvaluatedClassAnalyzer ca) {
        block1: {
            if (this.mom.registrationFineDebug()) {
                this.dputil.enter("analyzeFields", "ca=", ca);
            }
            if (!this.mom.registrationFineDebug()) break block1;
            this.dputil.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeAttributes(EvaluatedClassAnalyzer ca) {
        if (this.mom.registrationFineDebug()) {
            this.dputil.enter("analyzeAttributes", "ca=", ca);
        }
        try {
            Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> amap = this.mom.getAttributes(ca, ManagedObjectManagerInternal.AttributeDescriptorType.MBEAN_ATTR);
            this.getters.putAll(amap.first());
            this.setters.putAll(amap.second());
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("attributes=", amap);
            }
            HashSet<String> setterNames = new HashSet<String>(this.setters.keySet());
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("(Before removing getters):setterNames=", setterNames);
            }
            for (String str : this.getters.keySet()) {
                this.processAttribute(this.getters.get(str), this.setters.get(str));
                setterNames.remove(str);
            }
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("(After removing getters):setterNames=", setterNames);
            }
            for (String str : setterNames) {
                this.processAttribute(null, this.setters.get(str));
            }
        }
        finally {
            if (this.mom.registrationFineDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeObjectNameKeys(EvaluatedClassAnalyzer ca) {
        if (this.mom.registrationFineDebug()) {
            this.dputil.enter("analyzeObjectNameKeys", "ca=", ca);
        }
        try {
            List<EvaluatedFieldDeclaration> annotatedFields = ca.findFields(this.mom.forAnnotation(NameValue.class, EvaluatedFieldDeclaration.class));
            List<EvaluatedMethodDeclaration> annotatedMethods = ca.findMethods(this.mom.forAnnotation(NameValue.class, EvaluatedMethodDeclaration.class));
            if (annotatedMethods.size() == 0 && annotatedFields.size() == 0) {
                return;
            }
            EvaluatedMethodDeclaration annotatedMethod = annotatedMethods.get(0);
            if (annotatedMethods.size() > 1) {
                EvaluatedMethodDeclaration second = annotatedMethods.get(1);
                if (annotatedMethod.containingClass().equals(second.containingClass())) {
                    throw Exceptions.self.duplicateObjectNameKeyAttributes(annotatedMethod, second, annotatedMethod.containingClass().name());
                }
            }
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("annotatedMethod=", annotatedMethod);
            }
            this.nameAttributeDescriptor = AttributeDescriptor.makeFromAnnotated(this.mom, annotatedMethod, "Name", Exceptions.self.nameOfManagedObject(), ManagedObjectManagerInternal.AttributeDescriptorType.MBEAN_ATTR);
        }
        finally {
            if (this.mom.registrationFineDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Operation, ModelMBeanOperationInfo> makeOperation(final EvaluatedMethodDeclaration m) {
        SecurityManager sman;
        if (this.mom.registrationFineDebug()) {
            this.dputil.enter("makeOperation", "m=", m);
        }
        if ((sman = System.getSecurityManager()) != null) {
            sman.checkPermission(accessControlPermission);
        }
        AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                m.method().setAccessible(true);
                return m.method();
            }
        });
        try {
            String desc = this.mom.getDescription(m);
            EvaluatedType rtype = m.returnType();
            final TypeConverter rtc = rtype == null ? null : this.mom.getTypeConverter(rtype);
            List<EvaluatedType> atypes = m.parameterTypes();
            final ArrayList<TypeConverter> atcs = new ArrayList<TypeConverter>();
            ManagedOperation mo = this.mom.getAnnotation(m, ManagedOperation.class);
            Descriptor modelDescriptor = this.makeValidDescriptor(DescriptorIntrospector.descriptorForElement(m.element()), DescriptorType.operation, m.name());
            for (EvaluatedType ltype : atypes) {
                atcs.add(this.mom.getTypeConverter(ltype));
            }
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("desc=", desc);
                this.dputil.info("rtype=", rtype);
                this.dputil.info("rtc=", rtc);
                this.dputil.info("atcs=", atcs);
                this.dputil.info("atypes=", atypes);
                this.dputil.info("descriptor=", modelDescriptor);
            }
            Operation oper = new Operation(){

                @Override
                public Object evaluate(FacetAccessor target, List<Object> args) {
                    if (MBeanSkeleton.this.mom.runtimeDebug()) {
                        MBeanSkeleton.this.dputil.enter("Operation:evaluate", "taget=", target, "args=", args);
                    }
                    Object[] margs = new Object[args.size()];
                    Iterator<Object> argsIterator = args.iterator();
                    Iterator tcIterator = atcs.iterator();
                    int ctr = 0;
                    while (argsIterator.hasNext() && tcIterator.hasNext()) {
                        Object arg = argsIterator.next();
                        TypeConverter tc = (TypeConverter)tcIterator.next();
                        margs[ctr++] = tc.fromManagedEntity(arg);
                    }
                    if (MBeanSkeleton.this.mom.runtimeDebug()) {
                        MBeanSkeleton.this.dputil.info("Before invoke: margs=", Arrays.asList(margs));
                    }
                    Object result = target.invoke(m.method(), MBeanSkeleton.this.mom.runtimeDebug(), margs);
                    if (MBeanSkeleton.this.mom.runtimeDebug()) {
                        MBeanSkeleton.this.dputil.info("After invoke: result=", result);
                    }
                    if (rtc == null) {
                        return null;
                    }
                    return rtc.toManagedEntity(result);
                }
            };
            ParameterNames pna = m.annotation(ParameterNames.class);
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("pna=", pna.value());
            }
            if (pna != null && pna.value().length != atcs.size()) {
                throw Exceptions.self.parameterNamesLengthBad();
            }
            MBeanParameterInfo[] paramInfo = new MBeanParameterInfo[atcs.size()];
            int ctr = 0;
            for (TypeConverter tc : atcs) {
                paramInfo[ctr] = new MBeanParameterInfo(pna == null ? "arg" + ctr : pna.value()[ctr], tc.getManagedType().toString(), desc);
                ++ctr;
            }
            ModelMBeanOperationInfo operInfo = new ModelMBeanOperationInfo(m.name(), desc, paramInfo, rtc.getManagedType().toString(), mo.impact().ordinal(), modelDescriptor);
            if (this.mom.registrationFineDebug()) {
                this.dputil.info("operInfo=", operInfo);
            }
            Pair<Operation, ModelMBeanOperationInfo> pair = new Pair<Operation, ModelMBeanOperationInfo>(oper, operInfo);
            return pair;
        }
        finally {
            if (this.mom.registrationFineDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeOperations(EvaluatedClassAnalyzer ca) {
        if (this.mom.registrationFineDebug()) {
            this.dputil.enter("analyzeOperations", "ca=", ca);
        }
        try {
            List<EvaluatedMethodDeclaration> ops = ca.findMethods(this.mom.forAnnotation(ManagedOperation.class, EvaluatedMethodDeclaration.class));
            for (EvaluatedMethodDeclaration m : ops) {
                Pair<Operation, ModelMBeanOperationInfo> data = this.makeOperation(m);
                ModelMBeanOperationInfo info = data.second();
                ArrayList<String> dataTypes = new ArrayList<String>();
                for (MBeanParameterInfo pi : info.getSignature()) {
                    dataTypes.add(pi.getType());
                }
                Map<List<String>, Operation> map = this.operations.get(m.name());
                if (map == null) {
                    map = new HashMap<List<String>, Operation>();
                    this.operations.put(m.name(), map);
                }
                this.mom.putIfNotPresent(map, dataTypes, data.first());
                this.mbeanOperationInfoList.add(info);
            }
        }
        finally {
            if (this.mom.registrationFineDebug()) {
                this.dputil.exit();
            }
        }
    }

    private String getTypeName(AMXMetadata mbt, Class<?> cls) {
        String result = mbt.pathPart().length() > 0 ? mbt.pathPart() : this.mom.getStrippedName(cls);
        return result;
    }

    public MBeanSkeleton(EvaluatedClassDeclaration annotatedClass, EvaluatedClassAnalyzer ca, ManagedObjectManagerInternal mom) {
        this.mom = mom;
        this.mbeanType = mom.getAnnotation(annotatedClass, AMXMetadata.class);
        if (this.mbeanType == null) {
            this.mbeanType = defaultMBeanType;
        }
        this.type = this.getTypeName(this.mbeanType, annotatedClass.cls());
        this.sequenceNumber = new AtomicLong();
        this.setters = new HashMap<String, AttributeDescriptor>();
        this.getters = new HashMap<String, AttributeDescriptor>();
        this.operations = new HashMap<String, Map<List<String>, Operation>>();
        this.mbeanAttributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
        this.mbeanOperationInfoList = new ArrayList<ModelMBeanOperationInfo>();
        this.analyzeAttributes(ca);
        this.analyzeFields(ca);
        this.analyzeOperations(ca);
        this.analyzeObjectNameKeys(ca);
        this.descriptor = this.makeValidDescriptor(DescriptorIntrospector.descriptorForElement(annotatedClass.cls()), DescriptorType.mbean, this.type);
        this.mbInfo = this.makeMbInfo(mom.getDescription(annotatedClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() {
        if (this.mom.runtimeDebug()) {
            this.dputil.enter("getType", new Object[0]);
        }
        try {
            String string = this.type;
            return string;
        }
        finally {
            if (this.mom.runtimeDebug()) {
                this.dputil.exit(this.type);
            }
        }
    }

    public AMXMetadata getMBeanType() {
        return this.mbeanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(FacetAccessor fa, String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.mom.runtimeDebug()) {
            this.dputil.enter("getAttribute", "fa=", fa, "name=", name);
        }
        Object result = null;
        try {
            AttributeDescriptor getter = this.getters.get(name);
            if (getter == null) {
                if (this.mom.runtimeDebug()) {
                    this.dputil.info("Error in finding getter ", name);
                }
                throw Exceptions.self.couldNotFindAttribute(name);
            }
            Object object = result = getter.get(fa, this.mom.runtimeDebug());
            if (this.mom.runtimeDebug()) {
                this.dputil.exit(result);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (this.mom.runtimeDebug()) {
                this.dputil.exit(result);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(NotificationBroadcasterSupport emitter, FacetAccessor fa, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.mom.runtimeDebug()) {
            this.dputil.enter("setAttribute", "emitter=", emitter, "fa=", fa, "attribute=", attribute);
        }
        try {
            AttributeDescriptor setter;
            Object oldValue;
            String name = attribute.getName();
            Object value = attribute.getValue();
            AttributeDescriptor getter = this.getters.get(name);
            Object object = oldValue = getter == null ? null : getter.get(fa, this.mom.runtimeDebug());
            if (this.mom.runtimeDebug()) {
                this.dputil.info("oldValue=", oldValue);
            }
            if ((setter = this.setters.get(name)) == null) {
                if (this.mom.runtimeDebug()) {
                    this.dputil.info("Could not find setter");
                }
                throw Exceptions.self.couldNotFindWritableAttribute(name);
            }
            setter.set(fa, value, this.mom.runtimeDebug());
            AttributeChangeNotification notification = new AttributeChangeNotification(emitter, this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), "Changed attribute " + name, name, setter.tc().getManagedType().toString(), oldValue, value);
            if (this.mom.runtimeDebug()) {
                this.dputil.info("sending notification ", notification);
            }
            emitter.sendNotification(notification);
        }
        finally {
            if (this.mom.runtimeDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(FacetAccessor fa, String[] attributes) {
        if (this.mom.runtimeDebug()) {
            this.dputil.enter("getAttributes", "attributes=", Arrays.asList(attributes));
        }
        try {
            AttributeList result = new AttributeList();
            for (String str : attributes) {
                Object value;
                block8: {
                    value = null;
                    try {
                        value = this.getAttribute(fa, str);
                    }
                    catch (JMException ex) {
                        Exceptions.self.attributeGettingError(ex, str);
                        if (!this.mom.runtimeDebug()) break block8;
                        this.dputil.exception("getAttributes: ", ex);
                    }
                }
                Attribute attr = new Attribute(str, value);
                result.add(attr);
            }
            AttributeList attributeList = result;
            return attributeList;
        }
        finally {
            if (this.mom.runtimeDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(NotificationBroadcasterSupport emitter, FacetAccessor fa, AttributeList attributes) {
        if (this.mom.runtimeDebug()) {
            this.dputil.enter("setAttributes", "emitter=", emitter, "fa=", fa, "attributes=", attributes);
        }
        AttributeList result = new AttributeList();
        try {
            for (Object elem : attributes) {
                Attribute attr = (Attribute)elem;
                try {
                    this.setAttribute(emitter, fa, attr);
                    result.add(attr);
                }
                catch (JMException ex) {
                    Exceptions.self.attributeSettingError(ex, attr.getName());
                    if (!this.mom.runtimeDebug()) continue;
                    this.dputil.exception("Error in setting attribute" + attr.getName(), ex);
                }
            }
            AttributeList attributeList = result;
            return attributeList;
        }
        finally {
            if (this.mom.runtimeDebug()) {
                this.dputil.exit(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(FacetAccessor fa, String actionName, Object[] params, String[] sig) throws MBeanException, ReflectionException {
        List<String> signature = Arrays.asList(sig);
        List<Object> parameters = Arrays.asList(params);
        Object result = null;
        if (this.mom.runtimeDebug()) {
            this.dputil.enter("invoke", "fa=", fa, "actionName", actionName, "params=", parameters, "signature=", signature);
        }
        try {
            Map<List<String>, Operation> opMap = this.operations.get(actionName);
            if (opMap == null) {
                if (this.mom.runtimeDebug()) {
                    this.dputil.info("Operation not found");
                }
                throw Exceptions.self.couldNotFindOperation(actionName);
            }
            Operation op = opMap.get(signature);
            if (op == null) {
                if (this.mom.runtimeDebug()) {
                    this.dputil.info("Cound not find signature");
                }
                throw Exceptions.self.couldNotFindOperationAndSignature(actionName, signature);
            }
            result = op.evaluate(fa, parameters);
        }
        finally {
            if (this.mom.runtimeDebug()) {
                this.dputil.exit(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNameValue(FacetAccessor fa) throws MBeanException, ReflectionException {
        if (this.mom.runtimeDebug()) {
            this.dputil.enter("getNameValue", "fa=", fa);
        }
        String value = null;
        try {
            if (this.nameAttributeDescriptor == null) {
                if (this.mom.runtimeDebug()) {
                    this.dputil.info("nameAttributeDescriptor is null");
                }
            } else {
                value = this.nameAttributeDescriptor.get(fa, this.mom.runtimeDebug()).toString();
            }
            if (this.mom.runtimeDebug()) {
                this.dputil.exit(value);
            }
        }
        catch (Throwable throwable) {
            if (this.mom.runtimeDebug()) {
                this.dputil.exit(value);
            }
            throw throwable;
        }
        return value;
    }

    public ModelMBeanInfoSupport getMBeanInfo() {
        return this.mbInfo;
    }

    public ManagedObjectManagerInternal mom() {
        return this.mom;
    }

    @AMXMetadata
    private static class DefaultMBeanTypeHolder {
        private DefaultMBeanTypeHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DescriptorType {
        mbean,
        attribute,
        operation;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operation
    extends BinaryFunction<FacetAccessor, List<Object>, Object> {
    }
}

