/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.IncludeSubclass;
import org.glassfish.gmbal.InheritedAttribute;
import org.glassfish.gmbal.InheritedAttributes;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.generic.Algorithms;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.DumpIgnore;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.generic.FacetAccessorImpl;
import org.glassfish.gmbal.generic.ObjectUtility;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.generic.Predicate;
import org.glassfish.gmbal.generic.UnaryFunction;
import org.glassfish.gmbal.impl.AttributeDescriptor;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.MBeanImpl;
import org.glassfish.gmbal.impl.MBeanSkeleton;
import org.glassfish.gmbal.impl.MBeanTree;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.impl.TypeConverterImpl;
import org.glassfish.gmbal.typelib.EvaluatedClassAnalyzer;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;
import org.glassfish.gmbal.typelib.TypeEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectManagerImpl
implements ManagedObjectManagerInternal {
    private static ObjectUtility myObjectUtil = new ObjectUtility(true, 0, 4).useToString(EvaluatedType.class).useToString(ManagedObjectManager.class);
    private String domain;
    private ResourceBundle resourceBundle = null;
    private MBeanServer server;
    private MBeanTree tree;
    private final Map<EvaluatedClassDeclaration, MBeanSkeleton> skeletonMap;
    private final Map<EvaluatedType, TypeConverter> typeConverterMap;
    private final Map<AnnotatedElement, Map<Class, Annotation>> addedAnnotations;
    @DumpIgnore
    private DprintUtil dputil = null;
    private ManagedObjectManager.RegistrationDebugLevel regDebugLevel = ManagedObjectManager.RegistrationDebugLevel.NONE;
    private boolean runDebugFlag = false;
    private Comparator<String> revComp = new StringComparator();
    private final SortedSet<String> typePrefixes = new TreeSet<String>(this.revComp);

    public synchronized void suspendJMXRegistration() {
        this.tree.suspendRegistration();
    }

    public synchronized void resumeJMXRegistration() {
        this.tree.resumeRegistration();
    }

    public String toString() {
        return "ManagedObjectManagerImpl[domain=" + this.domain + "]";
    }

    private ManagedObjectManagerImpl() {
        this.server = ManagementFactory.getPlatformMBeanServer();
        this.skeletonMap = new WeakHashMap<EvaluatedClassDeclaration, MBeanSkeleton>();
        this.typeConverterMap = new WeakHashMap<EvaluatedType, TypeConverter>();
        this.addedAnnotations = new HashMap<AnnotatedElement, Map<Class, Annotation>>();
    }

    public ManagedObjectManagerImpl(String domain) {
        this();
        this.domain = domain;
        this.tree = new MBeanTree(this, domain, null, "type");
    }

    public ManagedObjectManagerImpl(ObjectName rootParentName) {
        this();
        this.domain = rootParentName.getDomain();
        this.tree = new MBeanTree(this, this.domain, rootParentName, "type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.registrationDebug()) {
            this.dputil.enter("close", new Object[0]);
        }
        try {
            this.tree.clear();
            this.skeletonMap.clear();
            this.typeConverterMap.clear();
            this.addedAnnotations.clear();
            this.server = null;
            this.resourceBundle = null;
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public synchronized ObjectName getRootParentName() {
        return this.tree.getRootParentName();
    }

    public synchronized NotificationEmitter createRoot() {
        return this.tree.setRoot(new Root(), null);
    }

    public synchronized NotificationEmitter createRoot(Object root) {
        return this.tree.setRoot(root, null);
    }

    public synchronized NotificationEmitter createRoot(Object root, String name) {
        return this.tree.setRoot(root, name);
    }

    public synchronized Object getRoot() {
        return this.tree.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MBeanSkeleton getSkeleton(EvaluatedClassDeclaration cls) {
        if (this.registrationDebug()) {
            this.dputil.enter("getSkeleton", cls);
        }
        try {
            MBeanSkeleton result = this.skeletonMap.get(cls);
            boolean newSkeleton = false;
            if (result == null) {
                newSkeleton = true;
                if (this.registrationDebug()) {
                    this.dputil.info("creating new Skeleton");
                }
                Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> pair = this.getClassAnalyzer(cls, ManagedObject.class);
                EvaluatedClassDeclaration annotatedClass = pair.first();
                EvaluatedClassAnalyzer ca = pair.second();
                result = this.skeletonMap.get(annotatedClass);
                if (result == null) {
                    result = new MBeanSkeleton(annotatedClass, ca, this);
                }
                this.skeletonMap.put(cls, result);
            }
            if (this.registrationFineDebug() || this.registrationDebug() && newSkeleton) {
                this.dputil.info("Skeleton=" + myObjectUtil.objectToString(result));
            }
            MBeanSkeleton mBeanSkeleton = result;
            return mBeanSkeleton;
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TypeConverter getTypeConverter(EvaluatedType type) {
        if (this.registrationFineDebug()) {
            this.dputil.enter("getTypeConverter", type);
        }
        TypeConverter result = null;
        try {
            boolean newTypeConverter = false;
            result = this.typeConverterMap.get(type);
            if (result == null) {
                if (this.registrationFineDebug()) {
                    this.dputil.info("Creating new TypeConverter");
                }
                this.typeConverterMap.put(type, new TypeConverterImpl.TypeConverterPlaceHolderImpl(type));
                result = TypeConverterImpl.makeTypeConverter(type, this);
                this.typeConverterMap.put(type, result);
                newTypeConverter = true;
            }
            if ((this.registrationFineDebug() || this.registrationDebug() && newTypeConverter) && this.registrationFineDebug()) {
                this.dputil.info("result=" + myObjectUtil.objectToString(result));
            }
        }
        finally {
            if (this.registrationFineDebug()) {
                this.dputil.exit(result);
            }
        }
        return result;
    }

    @Override
    public String getStrippedName(Class<?> cls) {
        String arg = cls.getName();
        for (String str : this.typePrefixes) {
            if (!arg.startsWith(str)) continue;
            return arg.substring(str.length() + 1);
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MBeanImpl constructMBean(Object obj, String name) {
        MBeanImpl result = null;
        if (this.registrationDebug()) {
            this.dputil.enter("constructMean", "obj=", obj, "name=", name);
        }
        try {
            Class<?> cls = obj.getClass();
            EvaluatedClassDeclaration cdecl = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(cls);
            MBeanSkeleton skel = this.getSkeleton(cdecl);
            String type = skel.getType();
            if (this.registrationDebug()) {
                this.dputil.info("Stripped type =", type);
            }
            result = new MBeanImpl(skel, obj, this.server, type);
            String objName = name;
            if (objName == null && (objName = skel.getNameValue(result)) == null) {
                objName = "na";
            }
            if (this.registrationDebug()) {
                this.dputil.info("Name value =", objName);
            }
            result.name(objName);
            if (this.registrationDebug()) {
                this.dputil.exit(result);
            }
        }
        catch (JMException exc) {
            if (this.registrationDebug()) {
                this.dputil.exception("Problem in fetching value of name", exc);
            }
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit(result);
            }
        }
        return result;
    }

    public synchronized NotificationEmitter register(Object parent, Object obj, String name) {
        if (this.registrationDebug()) {
            this.dputil.enter("register", "parent=", parent, "obj=", obj, "name=", name);
        }
        if (obj instanceof String) {
            throw Exceptions.self.objStringWrongRegisterCall((String)obj);
        }
        try {
            MBeanImpl mb = this.constructMBean(obj, name);
            NotificationEmitter notificationEmitter = this.tree.register(parent, obj, mb);
            return notificationEmitter;
        }
        catch (JMException exc) {
            throw Exceptions.self.exceptionInRegister(exc);
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    public synchronized NotificationEmitter register(Object parent, Object obj) {
        return this.register(parent, obj, null);
    }

    public synchronized NotificationEmitter registerAtRoot(Object obj, String name) {
        return this.register(this.tree.getRoot(), obj, name);
    }

    public synchronized NotificationEmitter registerAtRoot(Object obj) {
        return this.register(this.tree.getRoot(), obj, null);
    }

    public synchronized void unregister(Object obj) {
        if (this.registrationDebug()) {
            this.dputil.enter("unregister", "obj=", obj);
        }
        try {
            this.tree.unregister(obj);
        }
        catch (JMException exc) {
            throw Exceptions.self.exceptionInUnregister(exc);
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectName getObjectName(Object obj) {
        if (this.registrationDebug()) {
            this.dputil.enter("getObjectName", obj);
        }
        ObjectName result = null;
        try {
            result = this.tree.getObjectName(obj);
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(ObjectName oname) {
        if (this.registrationDebug()) {
            this.dputil.enter("getObject", oname);
        }
        Object result = null;
        try {
            result = this.tree.getObject(oname);
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit(result);
            }
        }
        return result;
    }

    @Override
    public synchronized FacetAccessor getFacetAccessor(Object obj) {
        MBeanImpl mb = this.tree.getMBeanImpl(obj);
        if (mb != null) {
            return this.tree.getFacetAccessor(obj);
        }
        return new FacetAccessorImpl(obj);
    }

    public synchronized String getDomain() {
        return this.domain;
    }

    public synchronized void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.server;
    }

    public synchronized void setResourceBundle(ResourceBundle rb) {
        this.resourceBundle = rb;
    }

    public synchronized ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public synchronized String getDescription(EvaluatedDeclaration element) {
        Description desc = element.annotation(Description.class);
        String result = desc == null ? Exceptions.self.noDescriptionAvailable() : desc.value();
        if (this.resourceBundle != null) {
            result = this.resourceBundle.getString(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAnnotation(AnnotatedElement element, Annotation annotation) {
        if (this.registrationDebug()) {
            this.dputil.enter("addAnnotation", "element = ", element, "annotation = ", annotation);
        }
        try {
            Annotation ann;
            Map<Class, Annotation> map = this.addedAnnotations.get(element);
            if (map == null) {
                if (this.registrationDebug()) {
                    this.dputil.info("Creating new Map<Class,Annotation>");
                }
                map = new HashMap<Class, Annotation>();
                this.addedAnnotations.put(element, map);
            }
            if ((ann = map.get(annotation.getClass())) != null) {
                if (this.registrationDebug()) {
                    this.dputil.info("Duplicate annotation");
                }
                throw Exceptions.self.duplicateAnnotation(element, annotation.getClass().getName());
            }
            map.put(annotation.getClass(), annotation);
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T extends Annotation> T getAnnotation(EvaluatedDeclaration element, Class<T> type) {
        if (this.registrationFineDebug()) {
            this.dputil.enter("getAnnotation", "element=", element, "type=", type.getName());
        }
        try {
            Object result = element.annotation(type);
            if (result == null) {
                Map<Class, Annotation> map;
                if (this.registrationFineDebug()) {
                    this.dputil.info("No annotation on element: trying addedAnnotations map");
                }
                if ((map = this.addedAnnotations.get(element.element())) != null) {
                    result = map.get(type);
                }
            }
            if (this.registrationFineDebug()) {
                this.dputil.info("result = " + result);
            }
            T t = result;
            return t;
        }
        finally {
            if (this.registrationFineDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> getClassAnalyzer(EvaluatedClassDeclaration cls, Class<? extends Annotation> annotationClass) {
        if (this.registrationDebug()) {
            this.dputil.enter("getClassAnalyzer", "cls = ", cls, "annotationClass = ", annotationClass);
        }
        try {
            EvaluatedClassAnalyzer ca = new EvaluatedClassAnalyzer(cls);
            EvaluatedClassDeclaration annotatedClass = Algorithms.getFirst(ca.findClasses(this.forAnnotation(annotationClass, EvaluatedClassDeclaration.class)), "No " + annotationClass.getName() + " annotation found on" + "EvaluatedClassAnalyzer " + ca);
            if (this.registrationDebug()) {
                this.dputil.info("annotatedClass = " + annotatedClass);
            }
            ArrayList<EvaluatedClassDeclaration> classes = new ArrayList<EvaluatedClassDeclaration>();
            classes.add(annotatedClass);
            IncludeSubclass incsub = annotatedClass.annotation(IncludeSubclass.class);
            if (incsub != null) {
                for (Class klass : incsub.value()) {
                    EvaluatedClassDeclaration ecd = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(klass);
                    classes.add(ecd);
                    if (!this.registrationDebug()) continue;
                    this.dputil.info("included subclass: " + klass);
                }
            }
            if (classes.size() > 1) {
                if (this.registrationDebug()) {
                    this.dputil.info("Getting new EvaluatedClassAnalyzer for included subclasses");
                }
                ca = new EvaluatedClassAnalyzer(classes);
            }
            Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> pair = new Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer>(annotatedClass, ca);
            return pair;
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<InheritedAttribute> getInheritedAttributes(EvaluatedClassAnalyzer ca) {
        if (this.registrationDebug()) {
            this.dputil.enter("getInheritedAttributes", "ca=", ca);
        }
        try {
            List<InheritedAttribute> isList;
            Predicate<EvaluatedClassDeclaration> pred = Algorithms.or(this.forAnnotation(InheritedAttribute.class, EvaluatedClassDeclaration.class), this.forAnnotation(InheritedAttributes.class, EvaluatedClassDeclaration.class));
            List<EvaluatedClassDeclaration> iaClasses = ca.findClasses(pred);
            List<InheritedAttribute> list = isList = Algorithms.flatten(iaClasses, new UnaryFunction<EvaluatedClassDeclaration, List<InheritedAttribute>>(){

                @Override
                public List<InheritedAttribute> evaluate(EvaluatedClassDeclaration cls) {
                    InheritedAttribute ia = ManagedObjectManagerImpl.this.getAnnotation(cls, InheritedAttribute.class);
                    InheritedAttributes ias = ManagedObjectManagerImpl.this.getAnnotation(cls, InheritedAttributes.class);
                    if (ia != null && ias != null) {
                        throw Exceptions.self.badInheritedAttributeAnnotation(cls);
                    }
                    ArrayList<InheritedAttribute> result = new ArrayList<InheritedAttribute>();
                    if (ia != null) {
                        result.add(ia);
                    } else if (ias != null) {
                        result.addAll(Arrays.asList(ias.value()));
                    }
                    return result;
                }
            });
            return list;
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    private AttributeDescriptor getAttributeDescriptorIfInherited(EvaluatedMethodDeclaration method, List<InheritedAttribute> ias, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        ADHolder adh = new ADHolder(method, adt);
        Algorithms.find(ias, adh);
        return adh.content();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <K, V> void putIfNotPresent(Map<K, V> map, K key, V value) {
        if (this.registrationFineDebug()) {
            this.dputil.enter("putIfNotPresent", "key=", key, "value=", value);
        }
        try {
            if (!map.containsKey(key)) {
                if (this.registrationFineDebug()) {
                    this.dputil.info("Adding key, value to map");
                }
                map.put(key, value);
            } else if (this.registrationFineDebug()) {
                this.dputil.info("Key,value already in map");
            }
        }
        finally {
            if (this.registrationFineDebug()) {
                this.dputil.exit();
            }
        }
    }

    static void checkFieldType(EvaluatedFieldDeclaration field) {
        if (!Modifier.isFinal(field.modifiers()) || !field.fieldType().isImmutable()) {
            Exceptions.self.illegalAttributeField(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> getAttributes(EvaluatedClassAnalyzer ca, final ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        if (this.registrationDebug()) {
            this.dputil.enter("getAttributes", new Object[0]);
        }
        try {
            final HashMap getters = new HashMap();
            final HashMap setters = new HashMap();
            Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> result = new Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>>(getters, setters);
            final List<InheritedAttribute> ias = this.getInheritedAttributes(ca);
            ca.findFields(new Predicate<EvaluatedFieldDeclaration>(){

                @Override
                public boolean evaluate(EvaluatedFieldDeclaration field) {
                    ManagedAttribute ma = field.annotation(ManagedAttribute.class);
                    if (ma == null) {
                        return false;
                    }
                    ManagedObjectManagerImpl.checkFieldType(field);
                    Description desc = ManagedObjectManagerImpl.this.getAnnotation(field, Description.class);
                    String description = desc == null ? "No description available for " + field.name() : desc.value();
                    AttributeDescriptor ad = AttributeDescriptor.makeFromAnnotated(ManagedObjectManagerImpl.this, field, ma.id(), description, adt);
                    ManagedObjectManagerImpl.this.putIfNotPresent(getters, ad.id(), ad);
                    return true;
                }
            });
            ca.findMethods(new Predicate<EvaluatedMethodDeclaration>(){

                @Override
                public boolean evaluate(EvaluatedMethodDeclaration method) {
                    AttributeDescriptor ad;
                    ManagedAttribute ma = method.annotation(ManagedAttribute.class);
                    if (ma == null) {
                        ad = ManagedObjectManagerImpl.this.getAttributeDescriptorIfInherited(method, ias, adt);
                    } else {
                        Description desc = ManagedObjectManagerImpl.this.getAnnotation(method, Description.class);
                        String description = desc == null ? "No description available for " + method.name() : desc.value();
                        ad = AttributeDescriptor.makeFromAnnotated(ManagedObjectManagerImpl.this, method, ma.id(), description, adt);
                    }
                    if (ad != null) {
                        if (ad.atype() == AttributeDescriptor.AttributeType.GETTER) {
                            ManagedObjectManagerImpl.this.putIfNotPresent(getters, ad.id(), ad);
                        } else {
                            ManagedObjectManagerImpl.this.putIfNotPresent(setters, ad.id(), ad);
                        }
                    }
                    return false;
                }
            });
            Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> pair = result;
            return pair;
        }
        finally {
            if (this.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    public synchronized void setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel level) {
        this.regDebugLevel = level;
        this.dputil = level != ManagedObjectManager.RegistrationDebugLevel.NONE ? new DprintUtil(this.getClass()) : null;
    }

    public synchronized void setRuntimeDebug(boolean flag) {
        this.runDebugFlag = flag;
    }

    public synchronized String dumpSkeleton(Object obj) {
        MBeanImpl impl = this.tree.getMBeanImpl(obj);
        if (impl == null) {
            return obj + " is not currently registered with mom " + this;
        }
        MBeanSkeleton skel = impl.skeleton();
        String skelString = myObjectUtil.objectToString(skel);
        return "Skeleton for MBean for object " + obj + ":\n" + skelString;
    }

    @Override
    public synchronized boolean registrationDebug() {
        return this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.NORMAL || this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.FINE;
    }

    @Override
    public synchronized boolean registrationFineDebug() {
        return this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.FINE;
    }

    @Override
    public synchronized boolean runtimeDebug() {
        return this.runDebugFlag;
    }

    public synchronized void stripPrefix(String ... args) {
        for (String str : args) {
            this.typePrefixes.add(str);
        }
    }

    @Override
    public synchronized <T extends EvaluatedDeclaration> Predicate<T> forAnnotation(final Class<? extends Annotation> annotation, Class<T> cls) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T elem) {
                return ManagedObjectManagerImpl.this.getAnnotation((EvaluatedDeclaration)elem, annotation) != null;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ADHolder
    implements Predicate<InheritedAttribute> {
        private final EvaluatedMethodDeclaration method;
        private final ManagedObjectManagerInternal.AttributeDescriptorType adt;
        private AttributeDescriptor content;

        public ADHolder(EvaluatedMethodDeclaration method, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
            this.method = method;
            this.adt = adt;
        }

        @Override
        public boolean evaluate(InheritedAttribute ia) {
            boolean result;
            AttributeDescriptor ad = AttributeDescriptor.makeFromInherited(ManagedObjectManagerImpl.this, this.method, ia.id(), ia.methodName(), ia.description(), this.adt);
            boolean bl = result = ad != null;
            if (result) {
                this.content = ad;
            }
            return result;
        }

        public AttributeDescriptor content() {
            return this.content;
        }
    }

    @ManagedObject
    @AMXMetadata(pathPart="GMBALROOT")
    @Description(value="Dummy class used when no root is specified")
    private static class Root {
        private Root() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return -o1.compareTo(o2);
        }
    }
}

