/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.ConstructorCreator;
import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.UnsatisfiedDependencyException;

public class InjectableParametizedConstructorCreator<T>
extends ConstructorCreator<T> {
    final Constructor<T> ctor;

    public InjectableParametizedConstructorCreator(Class<T> type, Constructor<T> ctor, Habitat habitat, MultiMap<String, String> metadata) {
        super(type, habitat, metadata);
        this.ctor = ctor;
    }

    @Override
    public T create(Inhabitant onBehalfOf) throws ComponentException {
        Annotation[][] paramsAnnotations = this.ctor.getParameterAnnotations();
        Class<?>[] paramTypes = this.ctor.getParameterTypes();
        Type[] genericParamTypes = this.ctor.getGenericParameterTypes();
        Object[] paramValues = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Annotation[] paramAnnotations;
            Class<?> paramType = paramTypes[i];
            for (Annotation a : paramAnnotations = paramsAnnotations[i]) {
                if (!a.annotationType().equals(Inject.class)) continue;
                for (InjectionResolver resolver : this.getInjectionResolvers(this.habitat)) {
                    AnnotatedElement annotatedElement = new AnnotatedElement(){

                        @Override
                        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                            return this.getAnnotation(annotationClass) != null;
                        }

                        @Override
                        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                            for (Annotation a : paramAnnotations) {
                                if (!a.annotationType().equals(annotationClass)) continue;
                                return (T)a;
                            }
                            return null;
                        }

                        @Override
                        public Annotation[] getAnnotations() {
                            return paramAnnotations;
                        }

                        @Override
                        public Annotation[] getDeclaredAnnotations() {
                            return paramAnnotations;
                        }
                    };
                    Object value = resolver.getValue(this, onBehalfOf, annotatedElement, genericParamTypes[i], paramType);
                    if (value == null) continue;
                    paramValues[i] = value;
                    break;
                }
                if (paramValues[i] != null || ((Inject)a).optional()) continue;
                throw new UnsatisfiedDependencyException(this.ctor, a);
            }
        }
        try {
            return this.ctor.newInstance(paramValues);
        }
        catch (InvocationTargetException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (InstantiationException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (IllegalAccessException e) {
            try {
                this.ctor.setAccessible(true);
                return this.ctor.newInstance(paramValues);
            }
            catch (Exception e1) {
                throw new ComponentException("Failed to create " + this.type, e);
            }
        }
        catch (LinkageError e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (RuntimeException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
    }
}

