/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.ContractLocator;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Scope;
import org.jvnet.hk2.component.SimpleServiceLocator;

class ContractLocatorImpl<T>
implements ContractLocator<T> {
    private final Logger logger = Logger.getLogger(ContractLocatorImpl.class.getName());
    private final SimpleServiceLocator habitat;
    private String name;
    private final Factory<T> getter;
    private final boolean byContract;

    ContractLocatorImpl(SimpleServiceLocator habitat, Class<T> clazz, boolean byContract) {
        this.habitat = habitat;
        this.byContract = byContract;
        this.getter = byContract ? this.getterByContract(clazz) : this.getterByType(clazz);
    }

    ContractLocatorImpl(SimpleServiceLocator habitat, String clazzName, boolean byContract) {
        this.habitat = habitat;
        this.byContract = byContract;
        this.getter = byContract ? this.getterByContract(clazzName) : this.getterByType(clazzName);
    }

    private Factory<T> getterByContract(final Class<T> clazz) {
        return new Factory<T>(){

            public T get() throws ComponentException {
                return ContractLocatorImpl.this.habitat.getComponent(clazz, ContractLocatorImpl.this.name);
            }
        };
    }

    private Factory<T> getterByContract(final String clazzName) {
        return new Factory<T>(){

            public T get() throws ComponentException {
                return ContractLocatorImpl.this.habitat.getComponent(clazzName, ContractLocatorImpl.this.name);
            }
        };
    }

    private Factory<T> getterByType(final Class<T> clazz) {
        return new Factory<T>(){

            public T get() throws ComponentException {
                return ContractLocatorImpl.this.habitat.getByType(clazz);
            }
        };
    }

    private Factory<T> getterByType(final String clazzName) {
        return new Factory<T>(){

            public T get() throws ComponentException {
                return ContractLocatorImpl.this.habitat.getByType(clazzName);
            }
        };
    }

    private void warnOnUsage() {
        this.logger.log(Level.WARNING, "name and scope are currently only appropriate for byContract usage");
    }

    public ContractLocator<T> named(String name) {
        this.name = name;
        if (null != name && !this.byContract) {
            this.warnOnUsage();
        }
        return this;
    }

    public ContractLocator<T> in(Scope scope) {
        throw new UnsupportedOperationException();
    }

    public ContractLocator<T> annotatedWith(Class<? extends Annotation> ... annotations) {
        throw new UnsupportedOperationException();
    }

    public Factory<T> getFactory() {
        return this.getter;
    }

    public T get() {
        return (T)this.getFactory().get();
    }

    public Collection<Provider<T>> all() {
        throw new UnsupportedOperationException();
    }

    public Provider<T> getProvider() {
        throw new UnsupportedOperationException();
    }
}

