/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.ConstructorCreator;
import com.sun.hk2.component.FactoryCreator;
import com.sun.hk2.component.InjectableParametizedConstructorCreator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.jvnet.hk2.annotations.Factory;
import org.jvnet.hk2.annotations.FactoryFor;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;

public class Creators {
    public static <T> Creator<T> create(Class<T> c, Habitat habitat, MultiMap<String, String> metadata) {
        Constructor<?>[] ctors;
        Factory f = c.getAnnotation(Factory.class);
        if (f != null) {
            return new FactoryCreator<T>(c, f.value(), habitat, metadata);
        }
        Inhabitant<?> factory = habitat.getInhabitantByAnnotation(FactoryFor.class, c.getName());
        if (factory != null) {
            return new FactoryCreator<T>(c, factory, habitat, metadata);
        }
        try {
            ctors = c.getDeclaredConstructors();
        }
        catch (Exception e) {
            ctors = c.getConstructors();
        }
        Constructor<?> noArgCtor = null;
        Constructor<?> defaultCtor = null;
        for (Constructor<?> ctor : ctors) {
            if (ctor.getParameterTypes().length == 0) {
                noArgCtor = ctor;
                continue;
            }
            Annotation[][] parametersAnnotations = ctor.getParameterAnnotations();
            boolean allParametersInjected = true;
            for (int i = 0; i < ctor.getParameterTypes().length; ++i) {
                boolean foundInject = false;
                for (int j = 0; j < parametersAnnotations[i].length; ++j) {
                    if (!parametersAnnotations[i][j].annotationType().equals(Inject.class)) continue;
                    foundInject = true;
                }
                if (foundInject) continue;
                allParametersInjected = false;
            }
            if (!allParametersInjected) continue;
            defaultCtor = ctor;
        }
        if (defaultCtor != null) {
            return new InjectableParametizedConstructorCreator<T>(c, defaultCtor, habitat, metadata);
        }
        if (noArgCtor != null) {
            return new ConstructorCreator<T>(c, habitat, metadata);
        }
        return null;
    }
}

