/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.EventPublishingInhabitant;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.RunLevelException;
import org.jvnet.hk2.component.RunLevelState;

public class RunLevelInhabitant<T, V>
extends EventPublishingInhabitant<T> {
    private static boolean enabled = true;
    private final int runLevel;
    private final RunLevelState<V> state;

    RunLevelInhabitant(Inhabitant<T> delegate, int runLevel, RunLevelState<V> state) {
        this(delegate, runLevel, state, null);
    }

    RunLevelInhabitant(Inhabitant<T> delegate, int runLevel, RunLevelState<V> state, InhabitantListener listener) {
        super(delegate, listener);
        this.runLevel = runLevel;
        this.state = state;
    }

    public static void enable(boolean enable) {
        enabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends T> type() {
        boolean wasInstantiated = this.isActive();
        try {
            Class clazz = super.type();
            return clazz;
        }
        finally {
            if (this.isActive() != wasInstantiated) {
                this.verifyState();
            }
        }
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        this.verifyState();
        return super.get(onBehalfOf);
    }

    protected void verifyState() throws ComponentException {
        if (!enabled) {
            return;
        }
        if (!this.isActive()) {
            RunLevel rl;
            Integer planned = this.state.getPlannedRunLevel();
            planned = null == planned ? -1 : planned;
            Integer current = this.state.getCurrentRunLevel();
            current = null == current ? -1 : current;
            if (!(null != planned && this.runLevel <= planned && this.runLevel <= current + 1 || null != (rl = this.type().getAnnotation(RunLevel.class)) && !rl.strict())) {
                throw new RunLevelException("unable to activate " + this + "; minimum expected RunLevel is: " + this.runLevel + "; planned is: " + planned + "; current is: " + current);
            }
        }
    }

    public RunLevelState<?> getState() {
        return this.state;
    }
}

