/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.ClassLoaderHolder;
import com.sun.hk2.component.RunLevelInhabitant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.RunLevelDefaultScope;
import org.jvnet.hk2.annotations.Priority;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.AsyncWaiter;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Enableable;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantActivator;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.InhabitantSorter;
import org.jvnet.hk2.component.RunLevelException;
import org.jvnet.hk2.component.RunLevelListener;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.RunLevelState;
import org.jvnet.hk2.component.ServiceContext;
import org.jvnet.hk2.component.SimpleServiceLocator;
import org.jvnet.hk2.component.internal.runlevel.Recorder;
import org.jvnet.hk2.component.internal.runlevel.RunLevelServiceStub;

public class DefaultRunLevelService
implements RunLevelService<Void>,
Enableable,
RunLevelState<Void>,
InhabitantListener,
HabitatListener,
InhabitantSorter,
InhabitantActivator {
    public static final int INITIAL_RUNLEVEL = -2;
    public static final String DEFAULT_NAME = "default";
    public static final boolean DEFAULT_ASYNC_ENABLED = false;
    public static final long DEFAULT_ASYNC_WAIT = 3000L;
    public static final Class<?> DEFAULT_SCOPE = RunLevelDefaultScope.class;
    private static final Logger logger = Logger.getLogger(DefaultRunLevelService.class.getName());
    private static final Level LEVEL = Level.FINE;
    private final Object lock = new Object();
    private final boolean asyncMode;
    private final ExecutorService exec;
    protected final String name;
    private final Class<?> targetScope;
    private final SimpleServiceLocator habitat;
    private RunLevelState<Void> delegate;
    private Integer current;
    private final HashMap<Integer, Recorder> recorders;
    private Worker worker;
    private boolean enabled = true;
    private RunLevelListener listener;
    private InhabitantSorter sorter;
    private InhabitantActivator activator;
    private final AsyncWaiter waiter;
    private RunLevelService<?> parent;

    public DefaultRunLevelService(SimpleServiceLocator habitat) {
        this(habitat, false, null, null, null);
    }

    public DefaultRunLevelService(SimpleServiceLocator habitat, boolean async, String name, Class<?> targetScope, HashMap<Integer, Recorder> recorders) {
        this.habitat = habitat;
        assert (null != habitat);
        this.asyncMode = async;
        if (this.asyncMode) {
            this.exec = Executors.newCachedThreadPool(new ThreadFactory(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Thread newThread(Runnable runnable) {
                    RunLevelServiceThread activeThread = new RunLevelServiceThread(runnable);
                    Object object = DefaultRunLevelService.this.lock;
                    synchronized (object) {
                        logger.log(Level.FINE, "new thread: {0}", activeThread);
                    }
                    return activeThread;
                }
            });
            this.waiter = null;
        } else {
            this.exec = null;
            this.waiter = new AsyncWaiter();
        }
        this.name = null == name ? DEFAULT_NAME : name;
        this.targetScope = null == targetScope ? RunLevelDefaultScope.class : targetScope;
        LinkedHashMap linkedHashMap = this.recorders = null == recorders ? new LinkedHashMap() : recorders;
        if (Habitat.class.isInstance(habitat)) {
            ((Habitat)Habitat.class.cast(habitat)).addHabitatListener(this);
        } else {
            this.inhabitantChanged(HabitatListener.EventType.HABITAT_INITIALIZED, null, null);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getDescription(false) + "delegate: " + this.delegate + ")";
    }

    public boolean isDefault() {
        return RunLevelDefaultScope.class.equals(this.targetScope);
    }

    private void assertNotIsDefault() {
        if (this.isDefault()) {
            throw new IllegalStateException("this operation is not supported on the default RunLevelService");
        }
    }

    public String getDescription(boolean extended) {
        StringBuilder b = new StringBuilder();
        b.append("curr=").append(this.getCurrentRunLevel()).append(", ");
        b.append("act=").append(this.getActivatingRunLevel()).append(", ");
        b.append("plan=").append(this.getPlannedRunLevel()).append(", ");
        b.append("scope=").append(this.getScopeName()).append(", ");
        if (extended) {
            b.append("thrd=").append(Thread.currentThread()).append(", ");
        }
        return b.toString();
    }

    private void setDelegate(RunLevelState<Void> stateProvider) {
        assert (this != stateProvider);
        this.delegate = stateProvider;
    }

    public void setParent(RunLevelService<?> parent) {
        this.assertNotIsDefault();
        this.parent = parent;
    }

    public RunLevelService<?> getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public RunLevelState<Void> getState() {
        return null == this.delegate ? this : this.delegate;
    }

    @Override
    public String getScopeName() {
        return null == this.delegate ? this.targetScope.getName() : this.delegate.getScopeName();
    }

    @Override
    public Integer getCurrentRunLevel() {
        return null == this.delegate ? this.current : this.delegate.getCurrentRunLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getPlannedRunLevel() {
        if (null == this.delegate) {
            Object object = this.lock;
            synchronized (object) {
                return null == this.worker ? null : this.worker.getPlannedRunLevel();
            }
        }
        return this.delegate.getPlannedRunLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getActivatingRunLevel() {
        Object object = this.lock;
        synchronized (object) {
            return null == this.worker ? null : this.worker.getActivatingRunLevel();
        }
    }

    @Override
    public void enable(boolean enabled) throws IllegalStateException {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected boolean accept(AbstractInhabitantImpl<?> i, int activeRunLevel) {
        if (i.isActive()) {
            return false;
        }
        Integer runlevel = this.getRunLevel(i);
        if (null != runlevel && Integer.valueOf(runlevel) != activeRunLevel) {
            return false;
        }
        RunLevel rl = i.getAnnotation(RunLevel.class);
        return rl.value() == activeRunLevel && rl.runLevelScope() == this.targetScope;
    }

    private void checkBinding(RunLevelInhabitant<?, ?> rli) {
        RunLevelState<?> state = rli.getState();
        if (state != this && RunLevelServiceStub.class.isInstance(state)) {
            RunLevelService delegate = ((RunLevelServiceStub)state).getDelegate();
            if (null != delegate) {
                assert (this == delegate || this.getParent() == delegate) : "delegate was " + delegate + " but was instead expected to be either " + this + " or " + this.getParent() + " for " + rli;
            } else {
                ((RunLevelServiceStub)state).activate(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCancelled(Worker worker) {
        Object object = this.lock;
        synchronized (object) {
            return this.worker != worker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(Worker worker) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCancelled(worker)) {
                this.worker = null;
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrent(Worker worker, Integer current) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCancelled(worker)) {
                return;
            }
            this.current = current;
        }
        this.event(worker, ListenerEvent.PROGRESS, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> getRecordersToRelease(HashMap<Integer, Recorder> list, int runLevel) {
        ArrayList<Integer> qualifying = new ArrayList<Integer>();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<Integer, Recorder> entry : this.recorders.entrySet()) {
                int entryKey = entry.getKey();
                if (entryKey < runLevel) continue;
                qualifying.add(entry.getKey());
            }
        }
        Collections.sort(qualifying);
        Collections.reverse(qualifying);
        return qualifying;
    }

    protected void event(Worker worker, ListenerEvent event, ServiceContext context, Throwable error) {
        this.event(worker, event, context, error, false);
    }

    protected void event(Worker worker, ListenerEvent event, ServiceContext context, Throwable error, boolean isHardInterrupt) {
        logger.log(LEVEL, "event {0} - " + this.getDescription(true), (Object)event);
        if (this.isCancelled(worker)) {
            logger.log(LEVEL, "Ignoring this notification!");
        } else {
            Interrupt lastInterrupt = null;
            Collection<RunLevelListener> activeListeners = this.getListeners();
            for (RunLevelListener listener : activeListeners) {
                try {
                    if (ListenerEvent.PROGRESS == event) {
                        listener.onProgress(this);
                        continue;
                    }
                    if (ListenerEvent.CANCEL == event) {
                        listener.onCancelled(this, context, this.current, isHardInterrupt);
                        continue;
                    }
                    listener.onError(this, context, error, true);
                }
                catch (Interrupt interrupt) {
                    lastInterrupt = interrupt;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "swallowing exception - " + this.getDescription(true), (Throwable)((Object)new RunLevelException(e)));
                }
            }
            if (null != lastInterrupt) {
                throw lastInterrupt;
            }
            if (null != error) {
                logger.log(LEVEL, "swallowing exception - " + context, (Throwable)((Object)new RunLevelException(error)));
            }
        }
    }

    public synchronized void setListener(RunLevelListener listener) {
        this.assertNotIsDefault();
        this.listener = listener;
    }

    protected synchronized Collection<RunLevelListener> getListeners() {
        Collection<RunLevelListener> listeners;
        if (null == this.listener) {
            Collection inhabs = this.habitat.getInhabitantsByContract(RunLevelListener.class.getName());
            listeners = this.narrow(inhabs);
        } else {
            listeners = Collections.singleton(this.listener);
        }
        return listeners;
    }

    protected <T> Collection<T> narrow(Collection<Inhabitant<T>> inhabs) {
        if (inhabs.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<T> services = new ArrayList<T>();
        for (Inhabitant<T> i : inhabs) {
            String scope = i.metadata().getFirst("runLevelScope");
            if (null != scope && !scope.equals(this.targetScope.getName())) continue;
            services.add(i.get());
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (InhabitantListener.class.isInstance(this.delegate)) {
            return ((InhabitantListener)InhabitantListener.class.cast(this.delegate)).inhabitantChanged(eventType, inhabitant);
        }
        AbstractInhabitantImpl ai = (AbstractInhabitantImpl)AbstractInhabitantImpl.class.cast(inhabitant);
        Integer activeRunLevel = this.getRunLevel(ai);
        if (null != activeRunLevel && InhabitantListener.EventType.INHABITANT_ACTIVATED == eventType) {
            Recorder activeRecorder;
            Object object = this.lock;
            synchronized (object) {
                activeRecorder = this.recorders.get(activeRunLevel);
                if (null == activeRecorder) {
                    activeRecorder = new Recorder(activeRunLevel, this.getScopeName());
                    this.recorders.put(activeRunLevel, activeRecorder);
                }
            }
            if (null != activeRecorder) {
                activeRecorder.inhabitantChanged(eventType, inhabitant);
            }
        }
        return true;
    }

    protected Integer getRunLevel(AbstractInhabitantImpl<?> i) {
        RunLevel rl;
        String runlevel = i.metadata().getOne("runLevel");
        Integer activeRunLevel = null != runlevel && runlevel.length() > 0 ? Integer.valueOf(runlevel) : (null == (rl = i.getAnnotation(RunLevel.class)) ? null : Integer.valueOf(rl.value()));
        return activeRunLevel;
    }

    @Override
    public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
        if (HabitatListener.EventType.HABITAT_INITIALIZED == eventType && this.isEnabled()) {
            this.proceedTo(-1);
        }
        return null != habitat && !habitat.isInitialized();
    }

    @Override
    public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant, String index, String name, Object service) {
        return true;
    }

    @Override
    public void proceedTo(int runLevel) {
        this.proceedTo(runLevel, false);
    }

    @Override
    public void interrupt() {
        this.proceedTo(null, true);
    }

    @Override
    public void interrupt(int runLevel) {
        this.proceedTo(runLevel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedTo(Integer runLevel, boolean isHardInterrupt) {
        if (!this.isEnabled()) {
            throw new IllegalStateException("disabled state");
        }
        if (null != runLevel && runLevel < -1) {
            throw new IllegalArgumentException();
        }
        Worker worker = this.worker;
        if (null != worker && worker.interrupt(isHardInterrupt, runLevel)) {
            return;
        }
        if (null != runLevel) {
            Object object = this.lock;
            synchronized (object) {
                worker = this.asyncMode ? new AsyncProceedToOp(runLevel) : new SyncProceedToOp(runLevel);
                this.worker = worker;
            }
            worker.proceedTo(runLevel);
        }
    }

    @Override
    public List<Inhabitant<?>> sort(List<Inhabitant<?>> inhabitants) {
        Collections.sort(inhabitants, DefaultRunLevelService.getInhabitantComparator());
        return inhabitants;
    }

    @Override
    public void activate(Inhabitant<?> inhabitant) {
        inhabitant.get();
    }

    @Override
    public void deactivate(Inhabitant<?> inhabitant) {
        inhabitant.release();
    }

    @Override
    public void awaitCompletion() throws InterruptedException, ExecutionException, TimeoutException {
        if (null != this.waiter) {
            long start = System.currentTimeMillis();
            logger.log(Level.FINER, "awaiting completion");
            this.waiter.waitForDone();
            logger.log(Level.FINER, "finished awaiting completion - {0} ms", System.currentTimeMillis() - start);
        }
    }

    @Override
    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        if (null != this.waiter) {
            long start = System.currentTimeMillis();
            logger.log(Level.FINER, "awaiting completion");
            boolean done = this.waiter.waitForDone(timeout, unit);
            logger.log(Level.FINER, "finished awaiting completion - {0} ms; done = {1}", new Object[]{System.currentTimeMillis() - start, done});
        }
    }

    public synchronized void setInhabitantSorter(InhabitantSorter sorter) {
        this.assertNotIsDefault();
        this.sorter = sorter;
    }

    protected synchronized InhabitantSorter getInhabitantSorter() {
        if (null != this.sorter) {
            return this.sorter;
        }
        Collection inhabs = this.habitat.getInhabitantsByContract(InhabitantSorter.class.getName());
        Collection sorters = this.narrow(inhabs);
        return sorters.isEmpty() ? this : (InhabitantSorter)sorters.iterator().next();
    }

    public synchronized void setInhabitantActivator(InhabitantActivator activator) {
        this.assertNotIsDefault();
        this.activator = activator;
    }

    protected synchronized InhabitantActivator getInhabitantActivator() {
        if (null != this.activator) {
            return this.activator;
        }
        Collection inhabs = this.habitat.getInhabitantsByContract(InhabitantActivator.class.getName());
        Collection activators = this.narrow(inhabs);
        return activators.isEmpty() ? this : (InhabitantActivator)activators.iterator().next();
    }

    protected ServiceContext serviceContext(Exception e, final Inhabitant<?> i) {
        if (null == i) {
            return null;
        }
        ServiceContext ctx = null;
        if (e instanceof ComponentException) {
            ctx = ((ComponentException)((Object)e)).getFailureContext();
        }
        if (null == ctx) {
            ctx = new ServiceContext(){

                @Override
                public ClassLoader getClassLoader() {
                    ClassLoader cl = ClassLoaderHolder.class.isInstance(i) ? ((ClassLoaderHolder)((Object)i)).getClassLoader() : i.getClass().getClassLoader();
                    return cl;
                }

                @Override
                public Inhabitant<?> getInhabitant() {
                    return i;
                }

                @Override
                public String getType() {
                    return i.typeName();
                }

                public String toString() {
                    return i.toString();
                }
            };
        }
        return ctx;
    }

    static Comparator<Inhabitant<?>> getInhabitantComparator() {
        return new Comparator<Inhabitant<?>>(){

            @Override
            public int compare(Inhabitant<?> o1, Inhabitant<?> o2) {
                int o2level;
                int o1level = o1.type().getAnnotation(Priority.class) != null ? o1.type().getAnnotation(Priority.class).value() : 5;
                int n = o2level = o2.type().getAnnotation(Priority.class) != null ? o2.type().getAnnotation(Priority.class).value() : 5;
                if (o1level == o2level) {
                    return 0;
                }
                if (o1level < o2level) {
                    return -1;
                }
                return 1;
            }
        };
    }

    public static class Interrupt
    extends RuntimeException {
        private Interrupt() {
        }
    }

    private static class RunLevelServiceThread
    extends Thread {
        private RunLevelServiceThread(Runnable r) {
            super(r);
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName() + "-" + System.currentTimeMillis());
        }
    }

    private class AsyncProceedToOp
    extends Worker
    implements Runnable {
        private Future<?> activeFuture;

        private AsyncProceedToOp(int runLevel) {
            super(runLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean interrupt(boolean isHard, Integer runLevel) {
            boolean haveFuture;
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                boolean bl = haveFuture = null != this.activeFuture;
                if (haveFuture) {
                    this.activeFuture.cancel(false);
                    this.activeFuture = null;
                }
            }
            if (haveFuture) {
                DefaultRunLevelService.this.event(this, ListenerEvent.CANCEL, null, null, isHard);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                this.activeFuture = null;
                this.isHardInterrupt = null;
            }
        }

        @Override
        public void proceedTo(int runLevel) {
            assert (null == this.activeFuture);
            this.activeFuture = DefaultRunLevelService.this.exec.submit(this);
        }

        @Override
        protected void checkInterrupt(Exception e, Inhabitant<?> i, Boolean isHard) {
            if (DefaultRunLevelService.this.isCancelled(this)) {
                throw new Interrupt();
            }
            super.checkInterrupt(e, i, isHard);
        }
    }

    private class SyncProceedToOp
    extends Worker {
        private final Thread activeThread;
        protected Integer nextPlannedAfterInterrupt;
        private boolean cancelIssued;

        private SyncProceedToOp(int runLevel) {
            super(runLevel);
            this.activeThread = Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean interrupt(boolean isHard, Integer runLevel) {
            Thread ourThread = Thread.currentThread();
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                Integer planned = this.getPlannedRunLevel();
                if (!isHard && null != planned && planned.equals(runLevel)) {
                    return true;
                }
                this.nextPlannedAfterInterrupt = runLevel;
                if (ourThread == this.activeThread) {
                    this.checkInterrupt(null, null, isHard);
                } else {
                    logger.log(LEVEL, "Interrupting thread {0} - " + DefaultRunLevelService.this.getDescription(true), this.activeThread);
                    this.isHardInterrupt = isHard;
                    this.activeThread.interrupt();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void proceedTo(int runLevel) {
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                this.planned = runLevel;
                this.nextPlannedAfterInterrupt = null;
                this.cancelIssued = false;
                this.isHardInterrupt = null;
            }
            try {
                this.run();
            }
            catch (Exception e) {
                this.handleInterruptException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkInterrupt(Exception e, Inhabitant<?> i, Boolean isHard) {
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                boolean cancelled = DefaultRunLevelService.this.isCancelled(this);
                if (cancelled || null != this.nextPlannedAfterInterrupt) {
                    if (!cancelled && this.canUpdateProceedTo(this.nextPlannedAfterInterrupt)) {
                        this.planned = this.nextPlannedAfterInterrupt;
                        this.nextPlannedAfterInterrupt = null;
                        e = null;
                    } else {
                        if (!this.cancelIssued) {
                            this.cancelIssued = true;
                            boolean wasHardInterrupt = this.isHardInterrupt(isHard, e);
                            this.isHardInterrupt = null;
                            DefaultRunLevelService.this.event(this, ListenerEvent.CANCEL, DefaultRunLevelService.this.serviceContext(e, i), null, wasHardInterrupt);
                        }
                        throw new Interrupt();
                    }
                }
            }
            super.checkInterrupt(e, i, isHard);
        }

        private boolean canUpdateProceedTo(Integer proposed) {
            if (null != this.upSide) {
                Integer planned = this.getPlannedRunLevel();
                Integer active = this.getActivatingRunLevel();
                if (null != planned && null != active && null != proposed) {
                    if (this.upSide.booleanValue() && proposed > active) {
                        return true;
                    }
                    if (!this.upSide.booleanValue() && proposed < active) {
                        return true;
                    }
                }
            }
            return false;
        }

        private void handleInterruptException(Exception e) {
            logger.log(LEVEL, "Interrupt caught - " + DefaultRunLevelService.this.getDescription(true), e);
            Thread currentThread = Thread.currentThread();
            Integer next = null;
            if (this.activeThread == currentThread) {
                next = this.nextPlannedAfterInterrupt;
            }
            if (null != next) {
                this.proceedTo(next);
            } else {
                logger.log(LEVEL, "swallowing exception - " + DefaultRunLevelService.this.getDescription(true), (Throwable)((Object)new RunLevelException(e)));
            }
        }
    }

    private abstract class Worker
    implements Runnable {
        protected volatile Integer planned;
        private Integer activeRunLevel;
        protected Boolean upSide;
        protected Boolean isHardInterrupt;

        protected Worker(int runLevel) {
            this.planned = runLevel;
        }

        public Integer getPlannedRunLevel() {
            return this.planned;
        }

        public Integer getActivatingRunLevel() {
            return this.activeRunLevel;
        }

        protected void checkInterrupt(Exception e, Inhabitant<?> i, Boolean isHard) {
            if (null != e) {
                ServiceContext ctx = DefaultRunLevelService.this.serviceContext(e, i);
                boolean isHardInterrupt = this.isHardInterrupt(isHard, e);
                if (isHardInterrupt) {
                    DefaultRunLevelService.this.event(this, ListenerEvent.CANCEL, ctx, e, isHardInterrupt);
                } else {
                    DefaultRunLevelService.this.event(this, ListenerEvent.ERROR, ctx, e, isHardInterrupt);
                }
            }
        }

        public abstract boolean interrupt(boolean var1, Integer var2);

        public abstract void proceedTo(int var1);

        @Override
        public void run() {
            logger.log(LEVEL, "proceedTo({0}) - " + DefaultRunLevelService.this.getDescription(true), this.planned);
            this.upSide = null;
            if (null != this.planned) {
                int current;
                int n = current = null == DefaultRunLevelService.this.getCurrentRunLevel() ? -2 : DefaultRunLevelService.this.getCurrentRunLevel();
                if (this.planned > current) {
                    this.upSide = true;
                    for (int rl = current + 1; rl <= this.planned; ++rl) {
                        this.upActiveRecorder(rl);
                    }
                } else if (this.planned < current) {
                    this.upSide = false;
                    DefaultRunLevelService.this.setCurrent(this, current);
                    this.down(current);
                } else {
                    this.upSide = false;
                    this.down(current + 1);
                }
            }
            DefaultRunLevelService.this.finished(this);
        }

        private void down(int start) {
            for (int rl = start; rl > this.planned; --rl) {
                this.downActiveRecorder(rl);
            }
        }

        private void upActiveRecorder(int runLevel) {
            this.activeRunLevel = runLevel;
            this.activateRunLevel();
            DefaultRunLevelService.this.setCurrent(this, runLevel);
        }

        private void activateRunLevel() {
            List<Inhabitant<?>> activations = new ArrayList();
            Collection runLevelInhabitants = DefaultRunLevelService.this.habitat.getInhabitantsByContract(RunLevel.class.getName());
            for (Inhabitant i : runLevelInhabitants) {
                AbstractInhabitantImpl ai = (AbstractInhabitantImpl)AbstractInhabitantImpl.class.cast(i);
                if (!DefaultRunLevelService.this.accept(ai, this.activeRunLevel)) continue;
                RunLevelInhabitant runLevelInhabitant = (RunLevelInhabitant)RunLevelInhabitant.class.cast(ai);
                DefaultRunLevelService.this.checkBinding(runLevelInhabitant);
                activations.add(runLevelInhabitant);
            }
            if (!activations.isEmpty()) {
                InhabitantSorter is = DefaultRunLevelService.this.getInhabitantSorter();
                if (logger.isLoggable(LEVEL)) {
                    logger.log(LEVEL, "sorting {0}", activations);
                }
                activations = is.sort(activations);
                assert (null != activations);
                InhabitantActivator ia = DefaultRunLevelService.this.getInhabitantActivator();
                if (null != DefaultRunLevelService.this.waiter) {
                    DefaultRunLevelService.this.waiter.clear();
                }
                for (Inhabitant<?> inhabitant : activations) {
                    if (logger.isLoggable(LEVEL)) {
                        logger.log(LEVEL, "activating {0} - " + DefaultRunLevelService.this.getDescription(true), inhabitant);
                    }
                    try {
                        ia.activate(inhabitant);
                        if (null != DefaultRunLevelService.this.waiter) {
                            DefaultRunLevelService.this.waiter.watchIfNecessary(inhabitant);
                        }
                        this.checkInterrupt(null, inhabitant, null);
                    }
                    catch (Exception e) {
                        this.checkInterrupt(e, inhabitant, null);
                    }
                }
                try {
                    ia.awaitCompletion(3000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    Inhabitant<?> inhabitant = null == DefaultRunLevelService.this.waiter ? null : DefaultRunLevelService.this.waiter.getLastInhabitantWorkingOn();
                    this.checkInterrupt(e, inhabitant, null);
                }
            }
        }

        protected void downActiveRecorder(int runLevel) {
            this.activeRunLevel = runLevel;
            this.deactiveRunLevel(runLevel);
            this.activeRunLevel = runLevel - 1;
            DefaultRunLevelService.this.setCurrent(this, this.activeRunLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactiveRunLevel(int runLevel) {
            List<Integer> downRecorders = DefaultRunLevelService.this.getRecordersToRelease(DefaultRunLevelService.this.recorders, runLevel);
            for (int current : downRecorders) {
                Inhabitant<?> i;
                Recorder downRecorder;
                Object object = DefaultRunLevelService.this.lock;
                synchronized (object) {
                    downRecorder = (Recorder)DefaultRunLevelService.this.recorders.get(current);
                }
                if (null == downRecorder) continue;
                InhabitantActivator ia = DefaultRunLevelService.this.getInhabitantActivator();
                while (null != (i = downRecorder.pop())) {
                    if (logger.isLoggable(LEVEL)) {
                        logger.log(LEVEL, "releasing {0} - " + DefaultRunLevelService.this.getDescription(true), i);
                    }
                    try {
                        ia.deactivate(i);
                        this.checkInterrupt(null, i, null);
                    }
                    catch (Exception e) {
                        this.checkInterrupt(e, i, null);
                    }
                }
                try {
                    ia.awaitCompletion();
                }
                catch (Exception e) {
                    this.checkInterrupt(e, null, null);
                }
            }
        }

        protected boolean isHardInterrupt(Boolean isHard, Throwable e) {
            if (null != isHard) {
                return isHard;
            }
            return null == this.isHardInterrupt ? false : this.isHardInterrupt;
        }
    }

    private static enum ListenerEvent {
        PROGRESS,
        CANCEL,
        ERROR;

    }
}

