/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Creators;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.junit.Hk2RunnerOptions;
import org.jvnet.hk2.junit.Hk2Test;
import org.jvnet.hk2.junit.Hk2TestServices;

public class Hk2Runner
extends Runner {
    final Class<?> testClass;
    final Description description;
    final List<Method> testMethods = new ArrayList<Method>();
    final Map<Description, Method> descriptionToTestMethods = new LinkedHashMap<Description, Method>();
    final List<Method> beforeMethods = new ArrayList<Method>();
    final List<Method> afterMethods = new ArrayList<Method>();
    private Object instance;
    private final Hk2RunnerOptions options;
    private final String testMethodRegEx;
    static Hk2TestServices singleton;

    public Hk2Runner(Class<?> testClass) {
        this.testClass = testClass;
        this.options = AbstractInhabitantImpl.getAnnotation(testClass, Hk2RunnerOptions.class, true);
        this.description = Description.createSuiteDescription(testClass);
        this.testMethodRegEx = System.getProperty("test.method");
        for (Method m : testClass.getDeclaredMethods()) {
            if (m.getAnnotation(Test.class) != null) {
                String mName = m.getName();
                if (null == this.testMethodRegEx || mName.matches(this.testMethodRegEx)) {
                    this.testMethods.add(m);
                    Description testDescription = Description.createTestDescription(testClass, (String)m.getName());
                    this.description.addChild(testDescription);
                    this.descriptionToTestMethods.put(testDescription, m);
                }
            }
            if (m.getAnnotation(Before.class) != null) {
                this.beforeMethods.add(m);
            }
            if (m.getAnnotation(After.class) == null) continue;
            this.afterMethods.add(m);
        }
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        if (this.testClass.isAnnotationPresent(Ignore.class)) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        for (Method m : this.testClass.getMethods()) {
            Failure failure;
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(BeforeClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(Description.createTestDescription(this.testClass, (String)m.getName()), (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(Description.createTestDescription(this.testClass, (String)m.getName()), (Throwable)e);
                notifier.fireTestFailure(failure);
            }
        }
        boolean reinitPerTest = null != this.options ? this.options.reinitializePerTest() : false;
        try {
            this.creatorInit();
        }
        catch (ComponentException e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)((Object)e)));
            return;
        }
        Iterator iter = this.description.getChildren().iterator();
        while (iter.hasNext()) {
            Failure failure;
            Method m;
            Description testDescription = (Description)iter.next();
            m = this.descriptionToTestMethods.get(testDescription);
            if (m.isAnnotationPresent(Ignore.class)) {
                notifier.fireTestIgnored(testDescription);
                continue;
            }
            try {
                this.runBefores(notifier);
            }
            catch (Throwable e1) {
                throw new RuntimeException(e1);
            }
            notifier.fireTestStarted(testDescription);
            try {
                m.invoke(this.instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(testDescription, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(testDescription, e.getTargetException());
                notifier.fireTestFailure(failure);
            }
            notifier.fireTestFinished(testDescription);
            try {
                this.runAfters(notifier);
            }
            catch (Throwable e1) {
                throw new RuntimeException(e1);
            }
            if (!reinitPerTest || !iter.hasNext()) continue;
            try {
                this.creatorInit();
            }
            catch (ComponentException e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)((Object)e)));
                return;
            }
        }
        for (Method m : this.testClass.getMethods()) {
            Failure failure;
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(AfterClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(Description.createTestDescription(this.testClass, (String)m.getName()), (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(Description.createTestDescription(this.testClass, (String)m.getName()), (Throwable)e);
                notifier.fireTestFailure(failure);
            }
        }
    }

    private void runMethods(RunNotifier notifier, List<Method> methods) throws Throwable {
        for (Method m : methods) {
            if (m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(this.instance, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Failure failure = new Failure(Description.createTestDescription(this.testClass, (String)m.getName()), cause);
                notifier.fireTestFailure(failure);
                throw cause;
            }
        }
    }

    private void runBefores(RunNotifier notifier) throws Throwable {
        this.runMethods(notifier, this.beforeMethods);
    }

    private void runAfters(RunNotifier notifier) throws Throwable {
        this.runMethods(notifier, this.afterMethods);
    }

    public static Habitat getHabitat() {
        return singleton.getHabitat();
    }

    public static Habitat createHabitat() {
        return singleton.createPopulatedHabitat();
    }

    private void creatorInit() {
        singleton = new Hk2TestServices(null == this.options ? null : this.options.habitatFactory(), null == this.options ? null : this.options.inhabitantsParserFactory(), null == this.options ? true : this.options.enableDefaultRunLevelService(), null == this.options ? true : this.options.enableRunLevelConstraints(), null == this.options ? null : this.options.classpathFilter(), null == this.options ? null : this.options.module());
        Habitat habitat = singleton.getHabitat();
        Creator<?> creator = Creators.create(this.testClass, habitat, new MultiMap<String, String>());
        this.instance = creator.create(creator);
        try {
            Hk2Test.Populator populator = (Hk2Test.Populator)Hk2Test.Populator.class.cast(this.instance);
            populator.populate(Hk2Runner.getHabitat());
        }
        catch (ClassCastException e) {
            Logger.getAnonymousLogger().fine(this.instance + " is not a populator");
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
        }
        creator.initialize(this.instance, creator);
    }
}

