/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.jsr330.spi.internal;

import com.sun.hk2.component.ConstructorWomb;
import com.sun.hk2.jsr330.spi.internal.Jsr330InjectionManager;
import com.sun.hk2.jsr330.spi.internal.Jsr330InjectionResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.tiger_types.Types;

public class Jsr330ConstructorWomb<T>
extends ConstructorWomb<T> {
    public Jsr330ConstructorWomb(Class<T> type, Habitat habitat, MultiMap<String, String> metadata) {
        super(type, habitat, metadata);
    }

    @Override
    protected InjectionManager createInjectionManager() {
        return new Jsr330InjectionManager();
    }

    @Override
    public T create(Inhabitant onBehalfOf) throws ComponentException {
        try {
            return this.type.newInstance();
        }
        catch (IllegalAccessException e) {
            return this.createFromInjectedCtor();
        }
        catch (InstantiationException e) {
            return this.createFromInjectedCtor();
        }
        catch (Exception e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
    }

    protected T createFromInjectedCtor() {
        List<Object> params = null;
        try {
            Constructor<T> ctor = this.getConstructor();
            ctor.setAccessible(true);
            params = this.getParameters(ctor);
            return ctor.newInstance(params.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ComponentException("Failed to create " + this.type, e);
        }
    }

    protected Constructor<T> getConstructor() throws Exception {
        for (Constructor<?> ctor : this.type.getDeclaredConstructors()) {
            Inject inject = ctor.getAnnotation(Inject.class);
            if (null == inject) continue;
            return ctor;
        }
        Constructor ctor = this.type.getDeclaredConstructor(null);
        if (null != ctor) {
            return ctor;
        }
        throw new ComponentException("no appropriate constructor");
    }

    protected List<Object> getParameters(Constructor<T> ctor) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Type paramType : ctor.getGenericParameterTypes()) {
            Class paramClass = Types.erasure(paramType);
            Object val = Types.isSubClassOf(paramClass, Provider.class) ? Jsr330InjectionResolver.getHolderInjectValue(this.habitat, ctor, paramType) : Jsr330InjectionResolver.get(this.habitat, ctor, ctor, paramClass);
            params.add(val);
        }
        return params;
    }

    @Override
    public void initialize(T t, Inhabitant onBehalfOf) throws ComponentException {
        super.initialize(t, onBehalfOf);
    }
}

