/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.jsr330.spi.internal;

import com.sun.hk2.component.InjectionResolver;
import com.sun.hk2.jsr330.spi.BasicProviderImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.tiger_types.Types;

public class Jsr330InjectionResolver
extends InjectionResolver<Inject> {
    @Inject
    private Habitat habitat;

    public Jsr330InjectionResolver() {
        super(Inject.class);
    }

    public Jsr330InjectionResolver(Habitat h) {
        super(Inject.class);
        this.habitat = h;
    }

    @Override
    public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type gtype, Class<V> type) throws ComponentException {
        Object result;
        if (Types.isSubClassOf(type, Provider.class)) {
            gtype = this.getGenericType(gtype, target);
            result = Jsr330InjectionResolver.getHolderInjectValue(this.habitat, onBehalfOf, gtype);
        } else {
            result = Jsr330InjectionResolver.get(this.habitat, onBehalfOf, target, type);
        }
        return result;
    }

    protected Type getGenericType(Type gtype, AnnotatedElement target) {
        Type[] gpTypes;
        if (null != gtype) {
            return gtype;
        }
        if (target instanceof Field) {
            return ((Field)target).getGenericType();
        }
        if (target instanceof Method && 1 == (gpTypes = ((Method)target).getGenericParameterTypes()).length) {
            return gpTypes[0];
        }
        throw new ComponentException("unknown type: " + target);
    }

    protected static <V> Provider<V> getHolderInjectValue(Habitat habitat, Object onBehalfOf, Type paramType) throws ComponentException {
        if (!ParameterizedType.class.isInstance(paramType)) {
            throw new ComponentException("unknown type: " + paramType.toString());
        }
        Type[] types = ((ParameterizedType)paramType).getActualTypeArguments();
        if (null == types || 1 != types.length) {
            throw new ComponentException(paramType.toString() + " on " + onBehalfOf);
        }
        Class paramClass = Types.erasure(types[0]);
        Inhabitant inhabitant = Jsr330InjectionResolver.getInhabitant(habitat, onBehalfOf, paramClass);
        return new BasicProviderImpl(inhabitant);
    }

    protected static <V> Inhabitant<V> getInhabitant(Habitat habitat, Object onBehalfOf, Class<V> type) {
        Inhabitant<V> result = habitat.getInhabitant(type, null);
        if (null == result) {
            result = habitat.getInhabitantByType(type);
        }
        return result;
    }

    protected static <V> V get(Habitat habitat, Object onBehalfOf, AnnotatedElement target, Class<V> type) {
        Annotation[] annotations = Jsr330InjectionResolver.qualifiers(target.getAnnotations());
        Named named = target.getAnnotation(Named.class);
        String name = null == named ? null : named.value();
        V result = null;
        if (null != name) {
            result = Jsr330InjectionResolver.getServiceInjectValue(habitat, type, name);
        }
        if (null == result && null != annotations) {
            result = Jsr330InjectionResolver.getServiceInjectValue(habitat, type, annotations);
        }
        if (null == result) {
            result = Jsr330InjectionResolver.getComponentInjectValue(habitat, type);
        }
        if (null == result && null == name && null == annotations) {
            result = Jsr330InjectionResolver.getServiceInjectValue(habitat, type, (String)null);
        }
        return result;
    }

    private static Annotation[] qualifiers(Annotation[] annotations) {
        if (null == annotations || 0 == annotations.length) {
            return null;
        }
        ArrayList<Annotation> result = null;
        for (Annotation ann : annotations) {
            if (null == ann.annotationType().getAnnotation(Qualifier.class)) continue;
            if (null == result) {
                result = new ArrayList<Annotation>();
            }
            result.add(ann);
        }
        return null == result ? null : result.toArray(annotations);
    }

    protected static <V> V getServiceInjectValue(Habitat habitat, Class<V> type, String name) throws ComponentException {
        V result = habitat.getComponent(type, name);
        return result;
    }

    protected static <V> V getServiceInjectValue(Habitat habitat, Class<V> type, Annotation[] annotations) throws ComponentException {
        Collection<Inhabitant<?>> candidates = habitat.getInhabitantsByContract(type.getName());
        for (Inhabitant<?> candidate : candidates) {
            if (!Jsr330InjectionResolver.matched(annotations, candidate.metadata())) continue;
            return (V)candidate.get();
        }
        return null;
    }

    protected static boolean matched(Annotation[] annotations, MultiMap<String, String> candidateMd) {
        for (Annotation ann : annotations) {
            String name;
            if (null == ann || candidateMd.contains("qualifier", name = ann.annotationType().getName())) continue;
            return false;
        }
        return true;
    }

    protected static <V> V getComponentInjectValue(Habitat habitat, Class<V> type) throws ComponentException {
        V result = habitat.getByType(type);
        return result;
    }

    @Override
    public boolean isOptional(AnnotatedElement annotated, Inject annotation) {
        return annotated.isAnnotationPresent(Optional.class);
    }
}

