/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator.maven;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jvnet.hk2.config.generator.AnnotationProcessorFactoryImpl;

public class ConfigGeneratorPlugin
extends AbstractMojo {
    private static final String GENERATED_SOURCES = "generated-sources";
    private static final String APT_GENERATED = "hk2-config-generator";
    private String basedir;
    private String buildDirectory;
    private String classpath;

    private void getAllJavaFiles(File directory, final LinkedList<String> foundFiles) {
        File[] allJavaFiles;
        for (File aJavaFile : allJavaFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File name) {
                if (name.isDirectory()) {
                    ConfigGeneratorPlugin.this.getAllJavaFiles(name, foundFiles);
                    return false;
                }
                return name.getName().endsWith(".java");
            }
        })) {
            foundFiles.add(aJavaFile.getAbsolutePath());
        }
    }

    private boolean getAllSources(LinkedList<String> args) throws MojoFailureException {
        File dotMe = new File(this.basedir);
        File src = new File(dotMe, "src");
        File main = new File(src, "main");
        File java = new File(main, "java");
        if (!java.exists() && !java.isDirectory()) {
            return false;
        }
        this.getAllJavaFiles(java, args);
        return true;
    }

    private String getClasspathFromFile() throws MojoFailureException {
        File classpathFile = new File(this.classpath);
        if (!classpathFile.exists() || classpathFile.isDirectory() || !classpathFile.canRead()) {
            throw new MojoFailureException("Could not find or read file " + classpathFile.getAbsolutePath());
        }
        try {
            FileInputStream is = new FileInputStream(classpathFile);
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader bis = new BufferedReader(reader);
            String line = bis.readLine();
            bis.close();
            ((Reader)reader).close();
            ((InputStream)is).close();
            return line;
        }
        catch (IOException ioe) {
            throw new MojoFailureException(ioe.getMessage());
        }
    }

    private void generateMinusSOption(LinkedList<String> args) {
        File buildDirectoryFile = new File(this.buildDirectory);
        File generatedSources = new File(buildDirectoryFile, GENERATED_SOURCES);
        File aptGeneratedFile = new File(generatedSources, APT_GENERATED);
        aptGeneratedFile.mkdirs();
        args.add("-s");
        args.add(aptGeneratedFile.getAbsolutePath());
    }

    private void generateMinusCPOption(LinkedList<String> args) throws MojoFailureException {
        if (this.classpath == null) {
            throw new MojoFailureException("classpath argument may not be null");
        }
        args.add("-cp");
        args.add(this.getClasspathFromFile());
    }

    private void internalExecute() throws Throwable {
        LinkedList<String> args = new LinkedList<String>();
        args.add("-nocompile");
        this.generateMinusSOption(args);
        this.generateMinusCPOption(args);
        if (!this.getAllSources(args)) {
            return;
        }
        String[] cmdLine = args.toArray(new String[args.size()]);
        Main.process((AnnotationProcessorFactory)new AnnotationProcessorFactoryImpl(), (String[])cmdLine);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.internalExecute();
        }
        catch (Throwable th) {
            if (th instanceof MojoExecutionException) {
                throw (MojoExecutionException)th;
            }
            if (th instanceof MojoFailureException) {
                throw (MojoFailureException)th;
            }
            int lcv = 0;
            for (Throwable cause = th; cause != null; cause = cause.getCause()) {
                System.out.println("Exception from hk2-config-generator[" + lcv++ + "]=" + cause.getMessage());
                cause.printStackTrace();
            }
            throw new MojoExecutionException(th.getMessage(), th);
        }
    }
}

