/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator.maven;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.hk2.config.generator.AnnotationProcessorFactoryImpl;

public class ConfigGeneratorPlugin
extends AbstractMojo {
    private static final String GENERATED_SOURCES = "generated-sources/hk2-config-generator/src";
    private static final String MAIN_NAME = "main";
    private static final String TEST_NAME = "test";
    private static final String JAVA_NAME = "java";
    protected MavenProject project;
    private File buildDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File outputDirectory;
    private boolean test;
    private boolean verbose;
    private String supportedProjectTypes;

    private void internalExecute() throws Throwable {
        File srcDir;
        List<String> projectTypes = Arrays.asList(this.supportedProjectTypes.split(","));
        File file = srcDir = this.test ? this.testSourceDirectory : this.sourceDirectory;
        if (!(projectTypes.contains(this.project.getPackaging()) && srcDir.exists() && srcDir.isDirectory())) {
            return;
        }
        File generatedSources = new File(this.buildDirectory, GENERATED_SOURCES);
        File phaseGeneratedFile = this.test ? new File(generatedSources, TEST_NAME) : new File(generatedSources, MAIN_NAME);
        File javaGeneratedFile = new File(phaseGeneratedFile, JAVA_NAME);
        javaGeneratedFile.mkdirs();
        LinkedList<String> args = new LinkedList<String>();
        args.add("-nocompile");
        args.add("-s");
        args.add(javaGeneratedFile.getAbsolutePath());
        args.add("-cp");
        args.add(this.getBuildClasspath());
        args.addAll(FileUtils.getFileNames((File)srcDir, (String)"**/*.java", (String)"", (boolean)true));
        Object[] cmdLine = args.toArray(new String[args.size()]);
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"-- Apt Command Line --");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)Arrays.toString(cmdLine));
            this.getLog().info((CharSequence)"");
        }
        Main.process((AnnotationProcessorFactory)new AnnotationProcessorFactoryImpl(), (String[])cmdLine);
        if (this.test) {
            this.project.addTestCompileSourceRoot(javaGeneratedFile.getAbsolutePath());
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Test Source directory: " + javaGeneratedFile + " added."));
            }
        } else {
            this.project.addCompileSourceRoot(javaGeneratedFile.getAbsolutePath());
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Source directory: " + javaGeneratedFile + " added."));
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.internalExecute();
        }
        catch (Throwable th) {
            if (th instanceof MojoExecutionException) {
                throw (MojoExecutionException)th;
            }
            if (th instanceof MojoFailureException) {
                throw (MojoFailureException)th;
            }
            int lcv = 0;
            for (Throwable cause = th; cause != null; cause = cause.getCause()) {
                this.getLog().error((CharSequence)("Exception from hk2-config-generator[" + lcv++ + "]=" + cause.getMessage()));
                cause.printStackTrace();
            }
            throw new MojoExecutionException(th.getMessage(), th);
        }
    }

    private String getBuildClasspath() {
        ArrayList artList;
        Iterator i;
        StringBuilder sb = new StringBuilder();
        if (this.test) {
            sb.append(this.outputDirectory.getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        if ((i = (artList = new ArrayList(this.project.getArtifacts())).iterator()).hasNext()) {
            sb.append(((Artifact)i.next()).getFile().getPath());
            while (i.hasNext()) {
                sb.append(File.pathSeparator);
                sb.append(((Artifact)i.next()).getFile().getPath());
            }
        }
        String classpath = sb.toString();
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"-- Classpath --");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)classpath);
            this.getLog().info((CharSequence)"");
        }
        return classpath;
    }
}

