/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JVar;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import java.lang.annotation.Annotation;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;

abstract class Property {
    private Boolean isKey = null;

    Property() {
    }

    abstract MemberDeclaration decl();

    String seedName() {
        return this.decl().getSimpleName();
    }

    abstract TypeMirror type();

    abstract void assign(JVar var1, JBlock var2, JExpression var3);

    <A extends Annotation> A getAnnotation(Class<A> a) {
        return (A)this.decl().getAnnotation(a);
    }

    final boolean isKey() {
        if (this.isKey == null) {
            this.isKey = this._isKey();
        }
        return this.isKey;
    }

    private boolean _isKey() {
        Element e = this.getAnnotation(Element.class);
        if (e != null && e.key()) {
            return true;
        }
        Attribute a = this.getAnnotation(Attribute.class);
        return a != null && a.key();
    }

    String inferName(String name) {
        if (name.length() == 0) {
            name = Dom.convertName((String)this.seedName());
        }
        return name;
    }

    static final class Field
    extends Property {
        final FieldDeclaration decl;

        public Field(FieldDeclaration decl) {
            this.decl = decl;
        }

        @Override
        MemberDeclaration decl() {
            return this.decl;
        }

        @Override
        TypeMirror type() {
            return this.decl.getType();
        }

        @Override
        void assign(JVar $target, JBlock block, JExpression rhs) {
            block.assign((JAssignmentTarget)$target.ref(this.decl.getSimpleName()), rhs);
        }
    }

    static final class Method
    extends Property {
        final MethodDeclaration decl;
        final boolean getter;

        public Method(MethodDeclaration decl) {
            this.decl = decl;
            this.getter = !decl.getReturnType().toString().equals("void");
        }

        @Override
        MemberDeclaration decl() {
            return this.decl;
        }

        @Override
        TypeMirror type() {
            if (this.getter) {
                return this.decl.getReturnType();
            }
            return ((ParameterDeclaration)this.decl.getParameters().iterator().next()).getType();
        }

        @Override
        void assign(JVar $target, JBlock block, JExpression rhs) {
            block.invoke((JExpression)$target, this.decl.getSimpleName()).arg(rhs);
        }
    }
}

