/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.istack.tools.APTTypeVisitor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import java.util.Collection;

class TypeMath {
    protected final AnnotationProcessorEnvironment env;
    static final APTTypeVisitor<TypeMirror, TypeDeclaration> baseClassFinder = new APTTypeVisitor<TypeMirror, TypeDeclaration>(){

        public TypeMirror onClassType(ClassType type, TypeDeclaration sup) {
            TypeMirror r = this.onDeclaredType((DeclaredType)type, sup);
            if (r != null) {
                return r;
            }
            if (type.getSuperclass() != null && (r = this.onClassType(type.getSuperclass(), sup)) != null) {
                return r;
            }
            return null;
        }

        protected TypeMirror onPrimitiveType(PrimitiveType type, TypeDeclaration param) {
            return null;
        }

        protected TypeMirror onVoidType(VoidType type, TypeDeclaration param) {
            return null;
        }

        public TypeMirror onInterfaceType(InterfaceType type, TypeDeclaration sup) {
            return this.onDeclaredType((DeclaredType)type, sup);
        }

        private TypeMirror onDeclaredType(DeclaredType t, TypeDeclaration sup) {
            if (t.getDeclaration().equals(sup)) {
                return t;
            }
            for (InterfaceType i : t.getSuperinterfaces()) {
                TypeMirror r = this.onInterfaceType(i, sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        public TypeMirror onTypeVariable(TypeVariable t, TypeDeclaration sup) {
            for (ReferenceType r : t.getDeclaration().getBounds()) {
                TypeMirror m = (TypeMirror)this.apply((TypeMirror)r, sup);
                if (m == null) continue;
                return m;
            }
            return null;
        }

        public TypeMirror onArrayType(ArrayType type, TypeDeclaration sup) {
            return null;
        }

        public TypeMirror onWildcard(WildcardType type, TypeDeclaration sup) {
            for (ReferenceType r : type.getLowerBounds()) {
                TypeMirror m = (TypeMirror)this.apply((TypeMirror)r, sup);
                if (m == null) continue;
                return m;
            }
            return null;
        }
    };
    final APTTypeVisitor<JExpression, JExpression> SIMPLE_VALUE_CONVERTER = new APTTypeVisitor<JExpression, JExpression>(){

        protected JExpression onPrimitiveType(PrimitiveType p, JExpression param) {
            String kind = p.getKind().toString();
            return JExpr.invoke((String)("as" + kind.charAt(0) + kind.substring(1).toLowerCase())).arg(param);
        }

        protected JExpression onClassType(ClassType type, JExpression param) {
            String qn = type.getDeclaration().getQualifiedName();
            if (qn.equals("java.lang.String")) {
                return param;
            }
            throw new UnsupportedOperationException();
        }

        protected JExpression onArrayType(ArrayType type, JExpression param) {
            throw new UnsupportedOperationException();
        }

        protected JExpression onInterfaceType(InterfaceType type, JExpression param) {
            throw new UnsupportedOperationException();
        }

        protected JExpression onTypeVariable(TypeVariable type, JExpression param) {
            throw new UnsupportedOperationException();
        }

        protected JExpression onVoidType(VoidType type, JExpression param) {
            throw new UnsupportedOperationException();
        }

        protected JExpression onWildcard(WildcardType type, JExpression param) {
            throw new UnsupportedOperationException();
        }
    };

    public TypeMath(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    TypeMirror isCollection(TypeMirror t) {
        TypeMirror collectionType = (TypeMirror)baseClassFinder.apply(t, (Object)this.env.getTypeDeclaration(Collection.class.getName()));
        if (collectionType != null) {
            DeclaredType d = (DeclaredType)collectionType;
            return (TypeMirror)d.getActualTypeArguments().iterator().next();
        }
        return null;
    }
}

