/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;

abstract class Property {
    private Boolean isKey = null;

    Property() {
    }

    abstract javax.lang.model.element.Element decl();

    String seedName() {
        return this.decl().getSimpleName().toString();
    }

    abstract TypeMirror type();

    abstract void assign(JVar var1, JBlock var2, JExpression var3);

    <A extends Annotation> A getAnnotation(Class<A> a) {
        return this.decl().getAnnotation(a);
    }

    final boolean isKey() {
        if (this.isKey == null) {
            this.isKey = this._isKey();
        }
        return this.isKey;
    }

    private boolean _isKey() {
        Element e = this.getAnnotation(Element.class);
        if (e != null && e.key()) {
            return true;
        }
        Attribute a = this.getAnnotation(Attribute.class);
        return a != null && a.key();
    }

    String inferName(String name) {
        if (name.length() == 0) {
            name = Dom.convertName((String)this.seedName());
        }
        return name;
    }

    static final class Field
    extends Property {
        final VariableElement field;

        public Field(VariableElement field) {
            this.field = field;
        }

        @Override
        javax.lang.model.element.Element decl() {
            return this.field;
        }

        @Override
        TypeMirror type() {
            return this.field.asType();
        }

        @Override
        void assign(JVar $target, JBlock block, JExpression rhs) {
            block.assign((JAssignmentTarget)$target.ref(this.field.getSimpleName().toString()), rhs);
        }
    }

    static final class Method
    extends Property {
        final ExecutableElement method;
        final boolean getter;

        public Method(ExecutableElement method) {
            this.method = method;
            this.getter = !method.getReturnType().toString().equals("void");
        }

        @Override
        javax.lang.model.element.Element decl() {
            return this.method;
        }

        @Override
        TypeMirror type() {
            if (this.getter) {
                return this.method.getReturnType();
            }
            return this.method.getParameters().iterator().next().asType();
        }

        @Override
        void assign(JVar $target, JBlock block, JExpression rhs) {
            block.invoke((JExpression)$target, this.method.getSimpleName().toString()).arg(rhs);
        }
    }
}

