/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.hk2.config.generator.ConfigInjectorGenerator;

public abstract class AbstractConfigGeneratorMojo
extends AbstractMojo {
    protected static final String GENERATED_SOURCES = "generated-sources/hk2-config-generator/src";
    protected static final String MAIN_NAME = "main";
    protected static final String TEST_NAME = "test";
    protected static final String JAVA_NAME = "java";
    protected MavenProject project;
    private boolean verbose;
    private String supportedProjectTypes;
    private String includes;
    private String excludes;

    protected abstract File getSourceDirectory();

    protected abstract File getGeneratedDirectory();

    protected abstract File getOutputDirectory();

    protected abstract void addCompileSourceRoot(String var1);

    private void internalExecute() throws Throwable {
        List<String> projectTypes = Arrays.asList(this.supportedProjectTypes.split(","));
        if (!(projectTypes.contains(this.project.getPackaging()) && this.getSourceDirectory().exists() && this.getSourceDirectory().isDirectory())) {
            return;
        }
        this.getGeneratedDirectory().mkdirs();
        String outputPath = this.getGeneratedDirectory().getAbsolutePath();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-proc:only");
        options.add("-s");
        options.add(outputPath);
        options.add("-d");
        options.add(outputPath);
        options.add("-cp");
        options.add(this.getBuildClasspath());
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(FileUtils.getFileNames((File)this.getSourceDirectory(), (String)this.includes, (String)this.excludes, (boolean)true));
        if (classNames.isEmpty()) {
            this.getLog().info((CharSequence)"No source file");
            return;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"-- AnnotationProcessing Command Line --");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)((Object)options).toString());
            this.getLog().info((CharSequence)((Object)classNames).toString());
            this.getLog().info((CharSequence)"");
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(classNames);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
        task.setProcessors(Collections.singleton(new ConfigInjectorGenerator()));
        boolean compilationResult = task.call();
        if (this.verbose) {
            this.getLog().info((CharSequence)("Result: " + (compilationResult ? "OK" : "!!! failed !!!")));
        }
        this.addCompileSourceRoot(outputPath);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Source directory: " + outputPath + " added."));
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.internalExecute();
        }
        catch (Throwable th) {
            if (th instanceof MojoExecutionException) {
                throw (MojoExecutionException)th;
            }
            if (th instanceof MojoFailureException) {
                throw (MojoFailureException)th;
            }
            int lcv = 0;
            for (Throwable cause = th; cause != null; cause = cause.getCause()) {
                this.getLog().error((CharSequence)("Exception from hk2-config-generator[" + lcv++ + "]=" + cause.getMessage()));
                cause.printStackTrace();
            }
            throw new MojoExecutionException(th.getMessage(), th);
        }
    }

    private String getBuildClasspath() {
        ArrayList artList;
        Iterator i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.project.getBuild().getOutputDirectory());
        sb.append(File.pathSeparator);
        if (!this.getOutputDirectory().getAbsolutePath().equals(this.project.getBuild().getOutputDirectory())) {
            sb.append(this.getOutputDirectory().getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        if ((i = (artList = new ArrayList(this.project.getArtifacts())).iterator()).hasNext()) {
            sb.append(((Artifact)i.next()).getFile().getPath());
            while (i.hasNext()) {
                sb.append(File.pathSeparator);
                sb.append(((Artifact)i.next()).getFile().getPath());
            }
        }
        String classpath = sb.toString();
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"-- Classpath --");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)classpath);
            this.getLog().info((CharSequence)"");
        }
        return classpath;
    }
}

