/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.enterprise.tools.apt.TypeHierarchyVisitor;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.glassfish.hk2.api.Metadata;
import org.jvnet.hk2.component.MultiMap;

public class InhabitantMetadataProcessor
extends TypeHierarchyVisitor<MultiMap<String, String>> {
    private final Map<DeclaredType, Model> models = new HashMap<DeclaredType, Model>();

    public MultiMap<String, String> process(TypeElement d) {
        this.visited.clear();
        MultiMap r = new MultiMap();
        this.check(d, (MultiMap<String, String>)r);
        return r;
    }

    @Override
    protected void check(TypeElement d, MultiMap<String, String> result) {
        this.checkAnnotations(d, result);
        super.check(d, result);
    }

    private void checkAnnotations(TypeElement d, MultiMap<String, String> result) {
        for (AnnotationMirror annotationMirror : d.getAnnotationMirrors()) {
            this.getModel(annotationMirror.getAnnotationType()).parse(annotationMirror, result);
            for (AnnotationMirror annotationMirror2 : annotationMirror.getAnnotationType().asElement().getAnnotationMirrors()) {
                this.getModel(annotationMirror2.getAnnotationType()).parse(annotationMirror2, result);
            }
        }
    }

    private boolean hasMetaAnnotation(AnnotationMirror a, Class<? extends Annotation> type) {
        return a.getAnnotationType().asElement().getAnnotation(type) != null;
    }

    private Model getModel(DeclaredType type) {
        Model model = this.models.get(type);
        if (model == null) {
            model = new Model(type);
            this.models.put(type, model);
        }
        return model;
    }

    private static final class Model {
        private final DeclaredType type;
        private final Map<ExecutableElement, String> metadataProperties = new HashMap<ExecutableElement, String>();

        public Model(DeclaredType type) {
            this.type = type;
            for (ExecutableElement e : ElementFilter.methodsIn(type.asElement().getEnclosedElements())) {
                Metadata im = e.getAnnotation(Metadata.class);
                if (im == null) continue;
                String name = im.value();
                if (name.length() == 0) {
                    name = ((TypeElement)type.asElement()).getQualifiedName().toString() + '.' + e.getSimpleName();
                }
                this.metadataProperties.put(e, name);
            }
        }

        public void parse(AnnotationMirror a, MultiMap<String, String> metadataBag) {
            assert (a.getAnnotationType().equals(this.type));
            block0: for (Map.Entry<ExecutableElement, String> e : this.metadataProperties.entrySet()) {
                Map<? extends ExecutableElement, ? extends AnnotationValue> vals = a.getElementValues();
                AnnotationValue value = vals.get(e.getKey());
                if (value != null) {
                    metadataBag.add((Object)e.getValue(), (Object)this.toString(value));
                    continue;
                }
                List<ExecutableElement> methods = ElementFilter.methodsIn(a.getAnnotationType().asElement().getEnclosedElements());
                for (ExecutableElement decl : methods) {
                    if (!e.getKey().equals(decl)) continue;
                    value = decl.getDefaultValue();
                    metadataBag.add((Object)e.getValue(), (Object)this.toString(value));
                    continue block0;
                }
            }
        }

        private String toString(AnnotationValue value) {
            TypeMirror tm;
            if (value.getValue() instanceof TypeMirror && (tm = (TypeMirror)value.getValue()).getKind().equals((Object)TypeKind.DECLARED)) {
                DeclaredType dt = (DeclaredType)tm;
                return this.getClassName((TypeElement)dt.asElement());
            }
            return value.toString();
        }

        private String getClassName(TypeElement d) {
            if (d.getEnclosingElement() != null) {
                return this.getClassName((TypeElement)d.getEnclosingElement()) + '$' + d.getSimpleName();
            }
            return d.getQualifiedName().toString();
        }
    }
}

