/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

abstract class TypeHierarchyVisitor<P> {
    protected final Set<TypeElement> visited = new HashSet<TypeElement>();

    TypeHierarchyVisitor() {
    }

    protected void check(TypeElement d, P param) {
        if (ElementKind.CLASS.equals((Object)d.getKind())) {
            this.checkClass(d, param);
        } else {
            this.checkInterface(d, param);
        }
    }

    protected void checkInterface(TypeElement id, P param) {
        this.checkSuperInterfaces(id, param);
    }

    protected void checkClass(TypeElement cd, P param) {
        TypeMirror sc = cd.getSuperclass();
        if (sc.getKind().equals((Object)TypeKind.NONE)) {
            this.check((TypeElement)((DeclaredType)sc).asElement(), param);
        }
        this.checkSuperInterfaces(cd, param);
    }

    protected void checkSuperInterfaces(TypeElement d, P param) {
        for (TypeMirror typeMirror : d.getInterfaces()) {
            TypeElement i = (TypeElement)((DeclaredType)typeMirror).asElement();
            if (!this.visited.add(i)) continue;
            this.check(i, param);
        }
    }
}

