/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.IntrospectionScanner;
import com.sun.hk2.component.LazyInhabitant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.InjectionTarget;
import org.jvnet.hk2.config.NoopConfigInjector;

@Service
public class ConfiguredScanner
implements IntrospectionScanner {
    @Inject
    Habitat habitat;
    ParsingContext context;

    public void parse(ParsingContext context, Holder<ClassLoader> loader) {
        this.context = context;
        AnnotationType configured = (AnnotationType)context.getTypes().getBy(Configured.class.getName());
        if (configured == null) {
            return;
        }
        for (AnnotatedElement ae : configured.allAnnotatedTypes()) {
            if (!(ae instanceof ExtensibleType)) continue;
            MultiMap metadata = new MultiMap();
            this.parse((ExtensibleType)ae, (MultiMap<String, String>)metadata);
            AnnotationModel c = ae.getAnnotation(Configured.class.getName());
            String elementName = (String)c.getValues().get("value");
            if (elementName == null || elementName.length() == 0) {
                elementName = Dom.convertName(ae.getName().substring(ae.getName().lastIndexOf(46) + 1));
            }
            metadata.add((Object)"target", (Object)ae.getName());
            LazyInhabitant inhabitant = new LazyInhabitant(this.habitat, loader, NoopConfigInjector.class.getName(), metadata);
            this.habitat.addIndex((Inhabitant)inhabitant, InjectionTarget.class.getName(), ae.getName());
            this.habitat.addIndex((Inhabitant)inhabitant, ConfigInjector.class.getName(), elementName);
        }
    }

    private void parse(ExtensibleType<?> type, MultiMap<String, String> metadata) {
        Stack<Object> q = new Stack<Object>();
        HashSet<ExtensibleType> visited = new HashSet<ExtensibleType>();
        q.push(type);
        while (!q.isEmpty()) {
            Collection interfaces;
            Collection methods;
            ExtensibleType t = (ExtensibleType)q.pop();
            if (null == t || !visited.add(t)) continue;
            if (t instanceof ClassModel) {
                for (FieldModel f : ((ClassModel)t).getFields()) {
                    this.generate(f);
                }
            }
            if (null != (methods = t.getMethods())) {
                for (MethodModel m : methods) {
                    this.generate(m, metadata);
                }
            }
            if (null != (interfaces = t.getInterfaces())) {
                for (InterfaceModel child : interfaces) {
                    q.add(child);
                }
            }
            if (t.getParent() == null) continue;
            q.add(t.getParent());
        }
    }

    private void generate(FieldModel f) {
    }

    private void generate(MethodModel m, MultiMap<String, String> metadata) {
        AnnotationModel attribute = m.getAnnotation(Attribute.class.getName());
        AnnotationModel element = m.getAnnotation(Element.class.getName());
        if (attribute != null) {
            this.generateAttribute(attribute, m, metadata);
            if (element != null) {
                throw new RuntimeException("Cannot have both @Element and @Attribute at the same time on method " + m.getName());
            }
        } else if (element != null) {
            this.generateElement(element, m, metadata);
        }
    }

    private void generateAttribute(AnnotationModel attribute, MethodModel m, MultiMap<String, String> metadata) {
        Boolean isKey;
        String refTypeAsString;
        String name = Dom.convertName(m.getName());
        String xmlTokenName = '@' + name;
        boolean isRequired = Boolean.parseBoolean((String)attribute.getValues().get("isRequired"));
        metadata.add((Object)xmlTokenName, (Object)(isRequired ? "required" : "optional"));
        String defaultValue = (String)attribute.getValues().get("defaultValue");
        if (defaultValue != null && !defaultValue.isEmpty()) {
            if (defaultValue.indexOf(44) != -1) {
                metadata.add((Object)xmlTokenName, (Object)("\"default:" + defaultValue + '\"'));
            } else {
                metadata.add((Object)xmlTokenName, (Object)("default:" + defaultValue));
            }
        }
        String signature = m.getSignature();
        String[] arguments = m.getArgumentTypes();
        if (arguments.length == 0) {
            refTypeAsString = m.getReturnType();
        } else {
            if (arguments.length != 1) {
                throw new RuntimeException("@Attribute method cannot have more than 1 argument " + m.getSignature());
            }
            refTypeAsString = arguments[0];
        }
        boolean isCollection = refTypeAsString.startsWith("java.util.List<L");
        if (isCollection) {
            refTypeAsString = refTypeAsString.substring("java.util.List<L".length());
        }
        metadata.add((Object)xmlTokenName, (Object)("datatype:" + refTypeAsString));
        Type refType = this.context.getTypes().getBy(refTypeAsString);
        Boolean isReference = (Boolean)attribute.getValues().get("reference");
        if (refType == null || isReference != null && isReference.booleanValue()) {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(isCollection, "leaf"));
            if (isReference != null && isReference.booleanValue()) {
                metadata.add((Object)xmlTokenName, (Object)"reference");
            }
        } else {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(isCollection, refTypeAsString));
        }
        if ((isKey = (Boolean)attribute.getValues().get("key")) != null && isKey.booleanValue()) {
            metadata.add((Object)"key", (Object)xmlTokenName);
            metadata.add((Object)"keyed-as", (Object)m.getDeclaringType().getName());
        }
    }

    private String makeCollectionIfNecessary(boolean isCollection, String value) {
        if (isCollection) {
            return "collection:" + value;
        }
        return value;
    }

    private void generateElement(AnnotationModel element, MethodModel m, MultiMap<String, String> metadata) {
        String refTypeAsString;
        String name = Dom.convertName(m.getName());
        String xmlTokenName = "<" + name + ">";
        String[] arguments = m.getArgumentTypes();
        if (arguments.length == 0) {
            refTypeAsString = m.getReturnType();
        } else {
            if (arguments.length != 1) {
                throw new RuntimeException("@Element method cannot have more than 1 argument " + m.getSignature());
            }
            refTypeAsString = arguments[0];
        }
        boolean isCollection = refTypeAsString.startsWith("java.util.List<L");
        if (isCollection) {
            refTypeAsString = refTypeAsString.substring("java.util.List<L".length());
        }
        Boolean isReference = (Boolean)element.getValues().get("reference");
        Type refType = this.context.getTypes().getBy(refTypeAsString);
        if (refType == null || isReference != null && isReference.booleanValue()) {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(isCollection, "leaf"));
            if (isReference != null && isReference.booleanValue()) {
                metadata.add((Object)xmlTokenName, (Object)"reference");
            }
        } else {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(isCollection, refTypeAsString));
        }
    }
}

