/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.bootstrap;

import com.sun.enterprise.module.InhabitantsDescriptor;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.DefaultErrorService;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.module.impl.HK2Factory;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.inhabitants.InhabitantParser;
import org.glassfish.hk2.inhabitants.InhabitantsParser;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.component.ComponentException;

public class Main {
    private static final String HABITAT_NAME = "default";

    public static void main(String[] args) {
        new Main().run(args);
    }

    public Main() {
        HK2Factory.initialize();
    }

    public void run(final String[] args) {
        try {
            final Main main = this;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        main.start(args);
                    }
                    catch (BootException e) {
                        e.printStackTrace();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected File getBootstrapFile() throws BootException {
        try {
            return Which.jarFile(this.getClass());
        }
        catch (IOException e) {
            throw new BootException("Failed to get bootstrap path", e);
        }
    }

    public void start(String[] args) throws BootException {
        Manifest mf;
        File bootstrap = this.getBootstrapFile();
        File root = bootstrap.getAbsoluteFile().getParentFile();
        if (root == null) {
            throw new BootException("Cannot find root installation from " + bootstrap);
        }
        String targetModule = this.findMainModuleName(bootstrap);
        ModulesRegistry mr = AbstractFactory.getInstance().createModulesRegistry();
        try {
            mf = new JarFile(bootstrap).getManifest();
        }
        catch (IOException e) {
            throw new BootException("Failed to read manifest from " + bootstrap);
        }
        this.createRepository(root, bootstrap, mf, mr);
        StartupContext context = new StartupContext(ArgumentManager.argsToMap(args));
        this.launch(mr, targetModule, context);
    }

    protected void setParentClassLoader(StartupContext context, ModulesRegistry mr) throws BootException {
        mr.setParentClassLoader(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Main.this.getClass().getClassLoader();
            }
        }));
    }

    protected void createRepository(File root, File bootstrapJar, Manifest mf, ModulesRegistry mr) throws BootException {
        String repos = mf.getMainAttributes().getValue("HK2-Repositories");
        if (repos != null) {
            StringTokenizer st = new StringTokenizer(repos);
            while (st.hasMoreTokens()) {
                String repoInfo;
                String repoId = st.nextToken();
                String repoKey = "HK2-Repository-" + repoId;
                try {
                    repoInfo = mf.getMainAttributes().getValue(repoKey);
                }
                catch (Exception e) {
                    throw new BootException("Invalid repository id " + repoId + " in " + bootstrapJar, e);
                }
                if (repoInfo == null) continue;
                this.addRepo(root, repoId, repoInfo, mr);
            }
        } else {
            this.addRepo(root, "lib", "uri=. type=directory", mr);
        }
    }

    private void addRepo(File root, String repoId, String repoInfo, ModulesRegistry mr) throws BootException {
        StringTokenizer st = new StringTokenizer(repoInfo);
        Properties props = new Properties();
        Pattern p = Pattern.compile("([^=]*)=(.*)");
        while (st.hasMoreTokens()) {
            Matcher m = p.matcher(st.nextToken());
            if (!m.matches()) continue;
            props.put(m.group(1), m.group(2));
        }
        String uri = props.getProperty("uri");
        if (uri == null) {
            uri = ".";
        }
        String type = props.getProperty("type");
        String weight = props.getProperty("weight");
        if ("directory".equalsIgnoreCase(type)) {
            File location = new File(uri);
            if (!location.isAbsolute()) {
                location = new File(root, uri);
            }
            if (!location.exists()) {
                throw new BootException("Non-existent directory: " + location);
            }
            try {
                location = location.getCanonicalFile();
            }
            catch (Exception e) {
                location = location.getAbsoluteFile();
            }
            try {
                DirectoryBasedRepository repo = new DirectoryBasedRepository(repoId, location);
                this.addRepo(repo, mr, weight);
            }
            catch (IOException e) {
                throw new BootException("Exception while adding " + repoId + " repository", e);
            }
        }
        throw new BootException("Invalid attributes for modules repository " + repoId + " : " + repoInfo);
    }

    protected void addRepo(Repository repo, ModulesRegistry mr, String weight) throws IOException {
        repo.initialize();
        int iWeight = 50;
        if (weight != null) {
            try {
                iWeight = Integer.parseInt(weight);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        mr.addRepository(repo, iWeight);
    }

    public ServiceLocator launch(ModulesRegistry registry, StartupContext context) throws BootException {
        return this.launch(registry, null, context);
    }

    public ServiceLocator launch(ModulesRegistry registry, String mainModuleName, StartupContext context) throws BootException {
        ServiceLocator serviceLocator = this.createServiceLocator(registry, context);
        this.launch(registry, serviceLocator, mainModuleName, context);
        return serviceLocator;
    }

    public ModuleStartup launch(ModulesRegistry registry, ServiceLocator serviceLocator, String mainModuleName, StartupContext context) throws BootException {
        ModuleStartup startupCode = this.findStartupService(registry, serviceLocator, mainModuleName, context);
        this.launch(startupCode, context);
        return startupCode;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleStartup findStartupService(ModulesRegistry registry, ServiceLocator serviceLocator, String mainModuleName, StartupContext context) throws BootException {
        Module mainModule;
        ModuleStartup startupCode = null;
        if (mainModuleName != null) {
            Collection<Module> modules = registry.getModules(mainModuleName);
            if (modules.size() != 1) {
                if (registry.getModules().isEmpty()) {
                    throw new BootException("Registry has no module at all");
                }
                throw new BootException("Cannot find main module " + mainModuleName + " : no such module");
            }
            mainModule = modules.iterator().next();
            String targetClassName = this.findModuleStartupClassName(mainModule, context.getPlatformMainServiceName(), HABITAT_NAME);
            if (targetClassName == null) {
                throw new BootException("Cannot find a ModuleStartup implementation in the META-INF/services/com.sun.enterprise.v3.ModuleStartup file, aborting");
            }
            Class<ModuleStartup> targetClass = null;
            ClassLoader currentCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(mainModule.getClassLoader());
                    return cl;
                }
            });
            try {
                ClassLoader moduleClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return mainModule.getClassLoader();
                    }
                });
                targetClass = moduleClassLoader.loadClass(targetClassName).asSubclass(ModuleStartup.class);
                startupCode = (ModuleStartup)serviceLocator.getService(targetClass, new Annotation[0]);
            }
            catch (ClassNotFoundException e) {
                try {
                    throw new BootException("Unable to load component of type " + targetClassName, e);
                    catch (ComponentException e2) {
                        throw new BootException("Unable to load component of type " + targetClassName, e2);
                    }
                }
                catch (Throwable throwable) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(currentCL){
                        final /* synthetic */ ClassLoader val$currentCL;
                        {
                            this.val$currentCL = classLoader;
                        }

                        @Override
                        public Object run() {
                            Thread.currentThread().setContextClassLoader(this.val$currentCL);
                            return null;
                        }
                    });
                    throw throwable;
                }
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        } else {
            List startups = serviceLocator.getAllServices(ModuleStartup.class, new Annotation[0]);
            if (startups.isEmpty()) {
                throw new BootException("No module has a ModuleStartup implementation");
            }
            if (startups.size() > 1) {
                String mainServiceName = context.getPlatformMainServiceName();
                startupCode = (ModuleStartup)serviceLocator.getService(ModuleStartup.class, mainServiceName, new Annotation[0]);
                if (startupCode == null) {
                    if (mainServiceName == null) {
                        Iterator itr = startups.iterator();
                        ModuleStartup a = (ModuleStartup)itr.next();
                        ModuleStartup b = (ModuleStartup)itr.next();
                        Module am = registry.find(a.getClass());
                        Module bm = registry.find(b.getClass());
                        throw new BootException(String.format("Multiple ModuleStartup found: %s from %s and %s from %s", a, am, b, bm));
                    }
                    throw new BootException(String.format("Cannot find %s ModuleStartup", mainServiceName));
                }
            } else {
                startupCode = (ModuleStartup)startups.iterator().next();
            }
            mainModule = registry.find(startupCode.getClass());
        }
        mainModule.setSticky(true);
        return startupCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceLocator createServiceLocator(ModulesRegistry registry, StartupContext context) throws BootException {
        this.setParentClassLoader(context, registry);
        ServiceLocator serviceLocator = ServiceLocatorFactory.getInstance().create(HABITAT_NAME);
        DynamicConfigurationService dcs = (DynamicConfigurationService)serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)serviceLocator));
        config.commit();
        config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)context));
        config.commit();
        config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)Logger.global));
        config.commit();
        config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)registry));
        config.commit();
        config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor(DefaultErrorService.class);
        config.commit();
        ClassLoader oldCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                return cl;
            }
        });
        try {
            registry.createServiceLocator(HABITAT_NAME, this.createInhabitantsParser(serviceLocator));
        }
        catch (Throwable throwable) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(oldCL){
                final /* synthetic */ ClassLoader val$oldCL;
                {
                    this.val$oldCL = classLoader;
                }

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(this.val$oldCL);
                    return null;
                }
            });
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return serviceLocator;
    }

    protected InhabitantsParser createInhabitantsParser(ServiceLocator habitat) {
        return new InhabitantsParser(habitat);
    }

    protected String findMainModuleName(File bootstrap) throws BootException {
        String targetModule;
        try {
            JarFile jarFile = new JarFile(bootstrap);
            Manifest manifest = jarFile.getManifest();
            Attributes attr = manifest.getMainAttributes();
            targetModule = attr.getValue("HK2-Main-Bundle");
            if (targetModule == null) {
                LogHelper.getDefaultLogger().warning("No Main-Bundle module found in manifest of " + bootstrap.getAbsoluteFile());
            }
        }
        catch (IOException ioe) {
            throw new BootException("Cannot get manifest from " + bootstrap.getAbsolutePath(), ioe);
        }
        return targetModule;
    }

    protected void launch(ModuleStartup startupCode, StartupContext context) throws BootException {
        startupCode.setStartupContext(context);
        startupCode.start();
    }

    protected String findModuleStartupClassName(Module mainModule, String serviceName, String habitatName) throws BootException {
        String index = serviceName == null || serviceName.isEmpty() ? ModuleStartup.class.getName() : ModuleStartup.class.getName() + ":" + serviceName;
        for (InhabitantsDescriptor d : mainModule.getMetadata().getHabitats(habitatName)) {
            try {
                for (InhabitantParser parser : d.createScanner()) {
                    for (String v : parser.getIndexes()) {
                        if (!v.equals(index)) continue;
                        parser.rewind();
                        return parser.getImplName();
                    }
                }
            }
            catch (IOException e) {
                throw new BootException("Failed to parse " + d.getSystemId(), e);
            }
        }
        throw new BootException("No " + ModuleStartup.class.getName() + " in " + mainModule);
    }
}

