/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.bootstrap.DescriptorFileFinder;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.hk2.bootstrap.impl.ClasspathDescriptorFileFinder;
import org.glassfish.hk2.utilities.DescriptorImpl;

public class HK2Populator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceLocator populate(ServiceLocator serviceLocator, DescriptorFileFinder fileFinder, PopulatorPostProcessor postProcessor) throws IOException {
        List<InputStream> descriptorFileInputStreams = fileFinder.findDescriptorFiles();
        DynamicConfigurationService dcs = (DynamicConfigurationService)serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        for (InputStream is : descriptorFileInputStreams) {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                DescriptorImpl descriptorImpl = new DescriptorImpl();
                boolean readOne = descriptorImpl.readObject(br);
                if (!readOne) continue;
                List<DescriptorImpl> descriptorImpls = postProcessor.process(descriptorImpl);
                for (DescriptorImpl d : descriptorImpls) {
                    config.bind((Descriptor)d);
                }
            }
            finally {
                br.close();
                config.commit();
            }
        }
        return serviceLocator;
    }

    public static ServiceLocator populate(ServiceLocator serviceLocator, DescriptorFileFinder fileFinder) throws IOException {
        return HK2Populator.populate(serviceLocator, fileFinder, new PopulatorPostProcessor(){

            @Override
            public List<DescriptorImpl> process(DescriptorImpl descriptorImpl) {
                ArrayList<DescriptorImpl> list = new ArrayList<DescriptorImpl>();
                list.add(descriptorImpl);
                return list;
            }
        });
    }

    public static ServiceLocator populate(ServiceLocator serviceLocator) throws IOException {
        return HK2Populator.populate(serviceLocator, new ClasspathDescriptorFileFinder());
    }
}

