/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.bootstrap;

import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.ContextDuplicatePostProcessor;
import com.sun.enterprise.module.bootstrap.DefaultErrorService;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.module.common_impl.LogHelper;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.bootstrap.DescriptorFileFinder;
import org.glassfish.hk2.bootstrap.HK2Populator;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.hk2.bootstrap.impl.ClasspathDescriptorFileFinder;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.external.generator.ServiceLocatorGeneratorImpl;

public class Main {
    private ServiceLocator serviceLocator;
    private boolean created = false;
    private DescriptorFileFinder descriptorFileFinder = new ClasspathDescriptorFileFinder();
    private ClassLoader parentClassLoader;
    public static final String DEFAULT_NAME = "default";

    public Main() {
        this.createServiceLocator();
    }

    public static void main(String[] args) {
        new Main().run(args);
    }

    public void run(final String[] args) {
        try {
            final Main main = this;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        main.start(args);
                    }
                    catch (BootException e) {
                        e.printStackTrace();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected File getBootstrapFile() throws BootException {
        try {
            return Which.jarFile(this.getClass());
        }
        catch (IOException e) {
            throw new BootException("Failed to get bootstrap path", e);
        }
    }

    public void start(String[] args) throws BootException {
        File bootstrap = this.getBootstrapFile();
        File root = bootstrap.getAbsoluteFile().getParentFile();
        if (root == null) {
            throw new BootException("Cannot find root installation from " + bootstrap);
        }
        String targetModule = this.findMainModuleName(bootstrap);
        StartupContext context = new StartupContext(ArgumentManager.argsToMap(args));
        this.launch(targetModule, context);
    }

    protected void createServiceLocator() {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        this.serviceLocator = factory.find(DEFAULT_NAME);
        if (this.serviceLocator == null) {
            this.serviceLocator = ServiceLocatorFactory.getInstance().create(DEFAULT_NAME, null, (ServiceLocatorGenerator)new ServiceLocatorGeneratorImpl());
            this.created = true;
        }
    }

    protected void defineParentClassLoader() throws BootException {
        this.parentClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Main.this.getClass().getClassLoader();
            }
        });
    }

    protected ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public ModuleStartup launch(String mainModuleName, StartupContext context) throws BootException {
        ModuleStartup startupCode = this.findStartupService(mainModuleName, context);
        this.launch(startupCode, context);
        return startupCode;
    }

    public ModuleStartup findStartupService(String mainModuleName, StartupContext context) throws BootException {
        try {
            ActiveDescriptor best = this.serviceLocator.getBestDescriptor((Filter)new MainFilter(mainModuleName));
            if (best == null) {
                throw new BootException("Cannot find main module " + (mainModuleName == null ? "" : mainModuleName) + " : no such module");
            }
            ServiceHandle handle = this.serviceLocator.getServiceHandle(best);
            ModuleStartup retVal = (ModuleStartup)handle.getService();
            return retVal;
        }
        catch (MultiException e) {
            throw new BootException("Unable to load service", e);
        }
    }

    public ServiceLocator createServiceLocator(StartupContext context) throws BootException {
        this.defineParentClassLoader();
        if (!this.created) {
            return this.serviceLocator;
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        new Habitat();
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)context));
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)Logger.global));
        config.addActiveDescriptor(DefaultErrorService.class);
        config.addActiveDescriptor(ContextDuplicatePostProcessor.class);
        config.commit();
        ClassLoader oldCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                return cl;
            }
        });
        try {
            this.populate();
        }
        catch (IOException ioe) {
            try {
                throw new BootException(ioe);
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(oldCL){
                    final /* synthetic */ ClassLoader val$oldCL;
                    {
                        this.val$oldCL = classLoader;
                    }

                    @Override
                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$oldCL);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return this.serviceLocator;
    }

    protected void populate() throws BootException, IOException {
        List populatorPostProcessors = this.serviceLocator.getAllServices(PopulatorPostProcessor.class, new Annotation[0]);
        HK2Populator.populate(this.serviceLocator, this.descriptorFileFinder, populatorPostProcessors.toArray(new PopulatorPostProcessor[populatorPostProcessors.size()]));
        HK2Populator.populateConfig(this.serviceLocator);
    }

    protected String findMainModuleName(File bootstrap) throws BootException {
        String targetModule;
        try {
            JarFile jarFile = new JarFile(bootstrap);
            Manifest manifest = jarFile.getManifest();
            Attributes attr = manifest.getMainAttributes();
            targetModule = attr.getValue("HK2-Main-Bundle");
            if (targetModule == null) {
                LogHelper.getDefaultLogger().warning("No Main-Bundle module found in manifest of " + bootstrap.getAbsoluteFile());
            }
        }
        catch (IOException ioe) {
            throw new BootException("Cannot get manifest from " + bootstrap.getAbsolutePath(), ioe);
        }
        return targetModule;
    }

    protected void launch(ModuleStartup startupCode, StartupContext context) throws BootException {
        startupCode.setStartupContext(context);
        startupCode.start();
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    protected DescriptorFileFinder getDescriptorFileFinder() {
        return this.descriptorFileFinder;
    }

    protected void setDescriptorFileFinder(DescriptorFileFinder descriptorFileFinder) {
        this.descriptorFileFinder = descriptorFileFinder;
    }

    protected void addPopulatorPostProcessor(PopulatorPostProcessor populatorPostProcessor) {
        if (!this.created) {
            return;
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)populatorPostProcessor));
        config.commit();
    }

    private static class MainFilter
    implements IndexedFilter {
        private final String name;

        private MainFilter(String name) {
            this.name = name;
        }

        public boolean matches(Descriptor d) {
            if (this.name == null) {
                return d.getName() == null;
            }
            return true;
        }

        public String getAdvertisedContract() {
            return ModuleStartup.class.getName();
        }

        public String getName() {
            return this.name;
        }
    }
}

