/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.inhabitants;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.inhabitants.InhabitantParser;
import org.glassfish.hk2.inhabitants.InhabitantStore;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantProviderInterceptor;
import org.jvnet.hk2.component.MultiMap;

public class InhabitantsParser
implements InhabitantStore {
    private final Logger logger = Logger.getLogger(InhabitantsParser.class.getName());
    public final ServiceLocator serviceLocator;
    private final Map<String, Class<?>> replacements = new HashMap();

    public InhabitantsParser(ServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public void drop(Class<?> component) {
        this.drop(component.getName());
    }

    public void drop(String fullyQualifiedClassName) {
        this.replace(fullyQualifiedClassName, null);
    }

    public void replace(Class<?> oldComponent, Class<?> newComponent) {
        this.replace(oldComponent.getName(), newComponent);
    }

    public void replace(String oldComponentFullyQualifiedClassName, Class<?> newComponent) {
        this.replacements.put(oldComponentFullyQualifiedClassName, newComponent);
    }

    public void parse(Iterable<InhabitantParser> scanner, HK2Loader classLoader) throws IOException {
        List interceptors;
        if (scanner == null) {
            return;
        }
        List list = interceptors = null == this.serviceLocator ? Collections.EMPTY_LIST : this.serviceLocator.getAllServices(InhabitantProviderInterceptor.class, new Annotation[0]);
        if (this.serviceLocator == null) {
            throw new RuntimeException("ServiceLocator not available");
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        for (InhabitantParser parser : scanner) {
            DynamicConfiguration config = dcs.createDynamicConfiguration();
            String implName = parser.getImplName();
            if (implName == null) continue;
            Iterable<String> indexes = parser.getIndexes();
            HashSet contracts = new HashSet();
            Iterator<String> indexIterator = indexes.iterator();
            MultiMap<String, String> metadata = parser.getMetaData();
            DescriptorImpl descriptor = new DescriptorImpl();
            descriptor.setImplementation(implName);
            descriptor.addAdvertisedContract(implName);
            descriptor.setScope(Singleton.class.getCanonicalName());
            descriptor.setLoader(classLoader);
            while (indexIterator.hasNext()) {
                String index = indexIterator.next();
                int idx = index.indexOf(58);
                if (-1 != idx) {
                    index = index.substring(0, idx);
                }
                descriptor.addAdvertisedContract(index);
            }
            for (String contract : descriptor.getAdvertisedContracts()) {
                List name = metadata.get((Object)contract);
                if (name.size() == 0) continue;
                descriptor.setName((String)name.get(0));
                break;
            }
            config.bind((Descriptor)descriptor);
            config.commit();
        }
    }

    private void reportProblem(String typeName, Exception e) {
        this.logger.log(Level.SEVERE, "Unable to create inhabitant for {0} - and therefore ignoring it; check classpath; re: {1}", new Object[]{typeName, e.getMessage()});
        this.logger.log(Level.INFO, "root cause", e);
    }

    protected boolean isFilteredInhabitant(InhabitantParser inhabitantParser) {
        return false;
    }

    protected boolean isFilteredInhabitant(String typeName) {
        return false;
    }

    protected void add(Inhabitant<?> i, InhabitantParser parser) {
        this.add(i);
        for (String v : parser.getIndexes()) {
            int idx = v.indexOf(58);
            if (idx == -1) {
                this.addIndex(i, v, null);
                continue;
            }
            String contract = v.substring(0, idx);
            String name = v.substring(idx + 1);
            this.addIndex(i, contract, name);
        }
    }

    public static String parseIndex(String v, StringBuilder name) {
        int idx = v.indexOf(58);
        if (-1 == idx) {
            return v;
        }
        String contract = v.substring(0, idx);
        if (null != name) {
            name.append(v.substring(idx + 1));
        }
        return contract;
    }

    @Override
    public void add(Inhabitant<?> i) {
        this.logger.log(Level.FINE, "adding inhabitant: {0} to habitat {1}", new Object[]{i, this.serviceLocator});
    }

    @Override
    public void addIndex(Inhabitant<?> i, String typeName, String name) {
        this.logger.log(Level.FINE, "adding index for inhabitant: {0} with typeName {1} and name {2} to habitat {3}", new Object[]{i, typeName, name, this.serviceLocator});
    }

    @Override
    public boolean remove(Inhabitant<?> i) {
        this.logger.log(Level.FINE, "removing inhabitant: {0} from habitat {1}", new Object[]{i, this.serviceLocator});
        return true;
    }

    @Override
    public boolean removeIndex(String index, String name) {
        this.logger.log(Level.FINE, "removing inhabitant index: {0},{1} from habitat {2}", new Object[]{index, name, this.serviceLocator});
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter((Filter)BuilderHelper.createContractFilter((String)index));
        config.commit();
        return true;
    }

    @Override
    public boolean removeIndex(String index, Object serviceOrInhabitant) {
        this.logger.log(Level.FINE, "removing inhabitant index: {0},{1} from habitat {2}", new Object[]{index, serviceOrInhabitant, this.serviceLocator});
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter((Filter)BuilderHelper.createContractFilter((String)index));
        config.commit();
        return true;
    }
}

