/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.hk2.component.AbstractInhabitantImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.jvnet.hk2.tracing.InhabitantTracing;
import org.jvnet.hk2.tracing.TracingThreadLocal;

public class TracingUtilities {
    public static boolean isEnabled() {
        return org.jvnet.hk2.tracing.TracingUtilities.isEnabled();
    }

    public static File getLocation() {
        File f;
        String location = System.getProperty("hk2.module.loglocation");
        if (location == null) {
            location = System.getProperty("user.dir");
        }
        if ((f = new File(location)).isAbsolute()) {
            return f;
        }
        return new File(System.getProperty("user.dir"), location);
    }

    public static void traceResolution(ModulesRegistry registry, long bundleId, String bundleName, Loader loader) {
        TracingUtilities.traceState(registry, "resolved", bundleId, bundleName, loader);
    }

    public static void traceStarted(ModulesRegistry registry, long bundleId, String bundleName, Loader loader) {
        TracingUtilities.traceState(registry, "started", bundleId, bundleName, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceState(ModulesRegistry registry, String state, long bundleId, String bundleName, Loader loader) {
        File out = new File(TracingUtilities.getLocation(), state + "-" + bundleId + ".log");
        FileWriter w = null;
        try {
            w = new FileWriter(out);
            ((Writer)w).append("\n");
            ((Writer)w).append("Module [" + bundleId + "] " + state + " " + bundleName + "\n");
            String prefix = "-";
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            InhabitantTracing tracing = TracingThreadLocal.get();
            Iterator itr = tracing.inOrder();
            ((Writer)w).append("\n");
            ((Writer)w).append("-----------------------------------\n");
            ((Writer)w).append("Inhabitants / stack combination\n");
            ((Writer)w).append("-----------------------------------\n");
            String currentBundleName = bundleName;
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement caller;
                int j;
                StackTraceElement element = stack[i];
                if (!element.getClassName().equals(AbstractInhabitantImpl.class.getName()) || !element.getMethodName().equals("get")) continue;
                for (j = i + 1; j < stack.length && (caller = stack[j]).getClassName().contains("hk2"); ++j) {
                }
                if (!itr.hasNext()) continue;
                ActiveDescriptor reason = (ActiveDescriptor)itr.next();
                StackTraceElement caller2 = stack[j];
                Module m = null;
                try {
                    if (reason.isReified()) {
                        m = registry.find(loader.loadClass(reason.getImplementation()));
                    }
                }
                catch (ClassNotFoundException e) {
                    m = null;
                }
                if (m != null && !m.getModuleDefinition().getName().equals(currentBundleName)) {
                    ((Writer)w).append("Looks like module " + currentBundleName + " was " + state + " because " + m.getName() + " was " + state + "\nSince " + m.getName() + " contains ");
                } else {
                    ((Writer)w).append("Requested by ");
                }
                if (m != null) {
                    currentBundleName = m.getName();
                }
                ((Writer)w).append(reason + " called from " + caller2.getClassName() + "." + caller2.getMethodName() + ":" + caller2.getLineNumber() + " metadata \n" + reason.getMetadata() + "\n");
                ((Writer)w).append("\n");
            }
            ((Writer)w).append("\n");
            ((Writer)w).append("-----------------------------------\n");
            ((Writer)w).append("Inhabitants initialization stack\n");
            ((Writer)w).append("-----------------------------------\n");
            itr = tracing.inOrder();
            while (itr.hasNext()) {
                Descriptor i = (Descriptor)itr.next();
                ((Writer)w).append(prefix + "> requested from " + i + "\n");
                prefix = prefix + "-";
            }
            ((Writer)w).append("\n");
            ((Writer)w).append("---------------------------\n");
            ((Writer)w).append("Complete thread stack Trace\n");
            ((Writer)w).append("---------------------------\n");
            for (StackTraceElement element : stack) {
                ((Writer)w).append(element.toString() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (w != null) {
                try {
                    ((Writer)w).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface Loader {
        public Class loadClass(String var1) throws ClassNotFoundException;
    }
}

