/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.single;

import com.sun.enterprise.module.InhabitantsDescriptor;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.enterprise.module.single.ProxyModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.inhabitants.InhabitantsParser;

public class ClassPathBasedModulesRegistry
extends ModulesRegistryImpl {
    final ClassLoader cLoader;
    final List<ModuleDefinition> moduleDefs = new ArrayList<ModuleDefinition>();
    final List<Module> modules = new ArrayList<Module>();

    public ClassPathBasedModulesRegistry(ClassLoader singleCL, String classPath) throws IOException {
        super(null);
        this.cLoader = singleCL;
        this.setParentClassLoader(this.cLoader);
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String classPathElement = st.nextToken();
            File f = new File(classPathElement);
            if (!f.exists()) continue;
            DefaultModuleDefinition md = new DefaultModuleDefinition(f);
            this.moduleDefs.add(md);
            this.add(md);
        }
        for (ModuleDefinition md : this.moduleDefs) {
            this.modules.add(new ProxyModule(this, md, this.cLoader));
        }
    }

    @Override
    public Module find(Class clazz) {
        Module m = super.find(clazz);
        if (m == null) {
            return this.modules.get(0);
        }
        return m;
    }

    @Override
    public Collection<Module> getModules(String moduleName) {
        return this.getModules();
    }

    @Override
    public Collection<Module> getModules() {
        ArrayList<Module> list = new ArrayList<Module>();
        list.addAll(this.modules);
        return list;
    }

    @Override
    public Module makeModuleFor(String name, String version, boolean resolve) throws ResolveError {
        for (int i = 0; i < this.moduleDefs.size(); ++i) {
            ModuleDefinition md = this.moduleDefs.get(i);
            if (!md.getName().equals(name)) continue;
            return this.modules.get(i);
        }
        return null;
    }

    @Override
    public void parseInhabitants(Module module, String name, InhabitantsParser inhabitantsParser) throws IOException {
        HK2Loader loader = new HK2Loader(){

            public Class<?> loadClass(String className) throws MultiException {
                try {
                    return ClassPathBasedModulesRegistry.this.cLoader.loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MultiException((Throwable)cnfe);
                }
            }
        };
        for (Module m : this.modules) {
            for (InhabitantsDescriptor d : m.getMetadata().getHabitats(name)) {
                inhabitantsParser.parse(d.createScanner(), loader);
            }
        }
    }
}

