/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.bootstrap;

import com.sun.enterprise.module.bootstrap.BootException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.util.List;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.bootstrap.ConfigPopulator;
import org.glassfish.hk2.bootstrap.DescriptorFileFinder;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.hk2.bootstrap.impl.ClasspathDescriptorFileFinder;
import org.glassfish.hk2.utilities.DescriptorImpl;

public class HK2Populator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populate(ServiceLocator serviceLocator, DescriptorFileFinder fileFinder, PopulatorPostProcessor postProcessor) throws IOException {
        List<InputStream> descriptorFileInputStreams = fileFinder.findDescriptorFiles();
        DynamicConfigurationService dcs = (DynamicConfigurationService)serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        for (InputStream is : descriptorFileInputStreams) {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                boolean readOne = false;
                do {
                    DescriptorImpl descriptorImpl;
                    if (!(readOne = (descriptorImpl = new DescriptorImpl()).readObject(br))) continue;
                    if (postProcessor == null) {
                        config.bind((Descriptor)descriptorImpl);
                        continue;
                    }
                    List<DescriptorImpl> descriptorImpls = postProcessor.process(descriptorImpl);
                    if (descriptorImpls == null) {
                        config.bind((Descriptor)descriptorImpl);
                        continue;
                    }
                    for (DescriptorImpl d : descriptorImpls) {
                        config.bind((Descriptor)d);
                    }
                } while (readOne);
            }
            finally {
                br.close();
            }
        }
        config.commit();
        try {
            HK2Populator.populateConfig(serviceLocator);
        }
        catch (BootException e) {
            e.printStackTrace();
        }
    }

    public static void populate(ServiceLocator serviceLocator, DescriptorFileFinder fileFinder) throws IOException {
        HK2Populator.populate(serviceLocator, fileFinder, null);
    }

    public static void populate(ServiceLocator serviceLocator) throws IOException {
        HK2Populator.populate(serviceLocator, new ClasspathDescriptorFileFinder());
    }

    private static void populateConfig(ServiceLocator serviceLocator) throws BootException {
        for (ConfigPopulator populator : serviceLocator.getAllServices(ConfigPopulator.class, new Annotation[0])) {
            populator.populateConfig(serviceLocator);
        }
    }
}

