/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.ctm;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.examples.ctm.Environment;
import org.glassfish.examples.ctm.TenantLocatorGenerator;
import org.glassfish.examples.ctm.TenantManager;
import org.glassfish.examples.ctm.TenantScoped;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;

@Singleton
public class EnvironmentFactory
implements Factory<Environment> {
    private final HashMap<String, ServiceLocator> backingLocators = new HashMap();
    private final TenantLocatorGenerator generator = new TenantLocatorGenerator();
    @Inject
    private TenantManager manager;

    @TenantScoped
    public Environment provide() {
        ServiceLocator locator = this.getCurrentLocator();
        return (Environment)locator.getService(Environment.class, new Annotation[0]);
    }

    public void dispose(Environment instance) {
    }

    private ServiceLocator getCurrentLocator() {
        if (this.manager.getCurrentTenant() == null) {
            throw new IllegalStateException("There is no current tenant");
        }
        ServiceLocator locator = this.backingLocators.get(this.manager.getCurrentTenant());
        if (locator == null) {
            locator = this.createNewLocator();
            this.backingLocators.put(this.manager.getCurrentTenant(), locator);
        }
        return locator;
    }

    private ServiceLocator createNewLocator() {
        return this.generator.generateLocatorPerTenant(this.manager.getCurrentTenant());
    }
}

