/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.ctm;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.examples.ctm.TenantManager;
import org.glassfish.examples.ctm.TenantScoped;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class TenantScopedContext
implements Context<TenantScoped> {
    private final HashMap<String, HashMap<ActiveDescriptor<?>, Object>> contexts = new HashMap();
    @Inject
    private TenantManager manager;

    public Class<? extends Annotation> getScope() {
        return TenantScoped.class;
    }

    public <T> T findOrCreate(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) {
        HashMap<ActiveDescriptor<?>, Object> mappings = this.getCurrentContext();
        Object retVal = mappings.get(activeDescriptor);
        if (retVal == null) {
            retVal = activeDescriptor.create(root);
            mappings.put(activeDescriptor, retVal);
        }
        return (T)retVal;
    }

    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        HashMap<ActiveDescriptor<?>, Object> mappings = this.getCurrentContext();
        return mappings.containsKey(descriptor);
    }

    public boolean isActive() {
        return this.manager.getCurrentTenant() != null;
    }

    public void shutdown() {
    }

    private HashMap<ActiveDescriptor<?>, Object> getCurrentContext() {
        if (this.manager.getCurrentTenant() == null) {
            throw new IllegalStateException("There is no current tenant");
        }
        HashMap<Object, Object> retVal = this.contexts.get(this.manager.getCurrentTenant());
        if (retVal == null) {
            retVal = new HashMap();
            this.contexts.put(this.manager.getCurrentTenant(), retVal);
        }
        return retVal;
    }

    public boolean supportsNullCreation() {
        return false;
    }
}

