/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.ctm;

import com.sun.enterprise.module.ModulesRegistry;
import java.net.URL;
import javax.inject.Inject;
import org.glassfish.examples.ctm.EnvironmentXml;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

@Service
public class TenantLocatorGenerator {
    public static final String ALICE = "Alice";
    public static final int ALICE_MIN = 1;
    public static final int ALICE_MAX = 2;
    public static final String BOB = "Bob";
    public static final int BOB_MIN = 10;
    public static final int BOB_MAX = 20;
    @Inject
    ServiceLocator systemServiceLocator;
    @Inject
    ModulesRegistry systemModulesRegistry;

    public ServiceLocator generateLocatorPerTenant(String tenantName) {
        if (tenantName == null) {
            throw new IllegalArgumentException();
        }
        ServiceLocator serviceLocator = this.systemModulesRegistry.createServiceLocator(this.systemServiceLocator, "tenant-scoped");
        this.populateWithConfig(serviceLocator, tenantName);
        return serviceLocator;
    }

    private void populateWithConfig(ServiceLocator serviceLocator, String tenantName) {
        System.out.println("Running populator for tenant " + tenantName);
        URL source = EnvironmentXml.class.getResource("/" + tenantName + ".xml");
        Habitat habitat = new Habitat(serviceLocator);
        ConfigParser parser = new ConfigParser((ServiceLocator)habitat);
        DomDocument doc = parser.parse(source, new DomDocument((ServiceLocator)habitat));
    }
}

