/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.http;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.glassfish.examples.http.RequestScope;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;

@Singleton
public class RequestContext
implements Context<RequestScope> {
    private final HashMap<ActiveDescriptor<?>, Object> requestScopedEntities = new HashMap();
    private boolean inRequest = false;

    public void startRequest() {
        this.inRequest = true;
    }

    public void stopRequest() {
        this.inRequest = false;
        for (Map.Entry<ActiveDescriptor<?>, Object> entry : this.requestScopedEntities.entrySet()) {
            ActiveDescriptor<?> ad = entry.getKey();
            Object value = entry.getValue();
            ad.dispose(value);
        }
        this.requestScopedEntities.clear();
    }

    public Class<? extends Annotation> getScope() {
        return RequestScope.class;
    }

    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        Object retVal = this.requestScopedEntities.get(activeDescriptor);
        if (retVal != null) {
            return (U)retVal;
        }
        retVal = activeDescriptor.create(root);
        this.requestScopedEntities.put(activeDescriptor, retVal);
        return (U)retVal;
    }

    public <U> U find(ActiveDescriptor<U> descriptor) {
        return (U)this.requestScopedEntities.get(descriptor);
    }

    public boolean isActive() {
        return this.inRequest;
    }
}

