/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validator.engine.resolver.DefaultTraversableResolver;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.resourceloading.ResourceBundleLocator;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.Version;
import org.hibernate.validator.xml.ValidationBootstrapParameters;
import org.hibernate.validator.xml.ValidationXmlParser;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements HibernateValidatorConfiguration,
ConfigurationState {
    private static final Logger log;
    private final ResourceBundleLocator defaultResourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages");
    private final MessageInterpolator defaultMessageInterpolator = new ResourceBundleMessageInterpolator(this.defaultResourceBundleLocator);
    private final TraversableResolver defaultTraversableResolver = new DefaultTraversableResolver();
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory = new ConstraintValidatorFactoryImpl();
    private final ValidationProviderResolver providerResolver;
    private ValidationBootstrapParameters validationBootstrapParameters;
    private boolean ignoreXmlConfiguration = false;
    private Set<InputStream> configurationStreams = new HashSet<InputStream>();
    private ConstraintMapping mapping;

    public ConfigurationImpl(BootstrapState state) {
        this.providerResolver = state.getValidationProviderResolver() == null ? state.getDefaultValidationProviderResolver() : state.getValidationProviderResolver();
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
    }

    public ConfigurationImpl(ValidationProvider provider) {
        if (provider == null) {
            throw new ValidationException("Assertion error: inconsistent ConfigurationImpl construction");
        }
        this.providerResolver = null;
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        this.validationBootstrapParameters.provider = provider;
    }

    @Override
    public HibernateValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    @Override
    public ConfigurationImpl messageInterpolator(MessageInterpolator interpolator) {
        this.validationBootstrapParameters.messageInterpolator = interpolator;
        return this;
    }

    @Override
    public ConfigurationImpl traversableResolver(TraversableResolver resolver) {
        this.validationBootstrapParameters.traversableResolver = resolver;
        return this;
    }

    @Override
    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.validationBootstrapParameters.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    @Override
    public HibernateValidatorConfiguration addMapping(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("The stream cannot be null.");
        }
        this.validationBootstrapParameters.mappings.add(stream);
        return this;
    }

    @Override
    public HibernateValidatorConfiguration addMapping(ConstraintMapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("The mapping cannot be null.");
        }
        this.mapping = mapping;
        return this;
    }

    @Override
    public HibernateValidatorConfiguration addProperty(String name, String value) {
        if (value != null) {
            this.validationBootstrapParameters.configProperties.put(name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatorFactory buildValidatorFactory() {
        this.parseValidationXml();
        ValidatorFactory factory = null;
        try {
            if (this.isSpecificProvider()) {
                factory = this.validationBootstrapParameters.provider.buildValidatorFactory(this);
            } else {
                Class<ValidationProvider<?>> providerClass = this.validationBootstrapParameters.providerClass;
                if (providerClass != null) {
                    for (ValidationProvider<?> provider : this.providerResolver.getValidationProviders()) {
                        if (!providerClass.isAssignableFrom(provider.getClass())) continue;
                        factory = provider.buildValidatorFactory(this);
                        break;
                    }
                    if (factory == null) {
                        throw new ValidationException("Unable to find provider: " + providerClass);
                    }
                } else {
                    List<ValidationProvider<?>> providers = this.providerResolver.getValidationProviders();
                    assert (providers.size() != 0);
                    factory = providers.get(0).buildValidatorFactory(this);
                }
            }
        }
        finally {
            for (InputStream in : this.configurationStreams) {
                try {
                    in.close();
                }
                catch (IOException io) {
                    log.warn("Unable to close input stream.");
                }
            }
        }
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        return factory;
    }

    @Override
    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.validationBootstrapParameters.messageInterpolator;
    }

    @Override
    public Set<InputStream> getMappingStreams() {
        return this.validationBootstrapParameters.mappings;
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.validationBootstrapParameters.constraintValidatorFactory;
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.validationBootstrapParameters.traversableResolver;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.validationBootstrapParameters.configProperties;
    }

    @Override
    public MessageInterpolator getDefaultMessageInterpolator() {
        return this.defaultMessageInterpolator;
    }

    @Override
    public TraversableResolver getDefaultTraversableResolver() {
        return this.defaultTraversableResolver;
    }

    @Override
    public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    @Override
    public ResourceBundleLocator getDefaultResourceBundleLocator() {
        return this.defaultResourceBundleLocator;
    }

    public ConstraintMapping getMapping() {
        return this.mapping;
    }

    private boolean isSpecificProvider() {
        return this.validationBootstrapParameters.provider != null;
    }

    private void parseValidationXml() {
        if (this.ignoreXmlConfiguration) {
            log.info("Ignoring XML configuration.");
            if (this.validationBootstrapParameters.messageInterpolator == null) {
                this.validationBootstrapParameters.messageInterpolator = this.defaultMessageInterpolator;
            }
            if (this.validationBootstrapParameters.traversableResolver == null) {
                this.validationBootstrapParameters.traversableResolver = this.defaultTraversableResolver;
            }
            if (this.validationBootstrapParameters.constraintValidatorFactory == null) {
                this.validationBootstrapParameters.constraintValidatorFactory = this.defaultConstraintValidatorFactory;
            }
        } else {
            ValidationBootstrapParameters xmlParameters = new ValidationXmlParser().parseValidationXml();
            this.applyXmlSettings(xmlParameters);
        }
    }

    private void applyXmlSettings(ValidationBootstrapParameters xmlParameters) {
        this.validationBootstrapParameters.providerClass = xmlParameters.providerClass;
        if (this.validationBootstrapParameters.messageInterpolator == null) {
            this.validationBootstrapParameters.messageInterpolator = xmlParameters.messageInterpolator != null ? xmlParameters.messageInterpolator : this.defaultMessageInterpolator;
        }
        if (this.validationBootstrapParameters.traversableResolver == null) {
            this.validationBootstrapParameters.traversableResolver = xmlParameters.traversableResolver != null ? xmlParameters.traversableResolver : this.defaultTraversableResolver;
        }
        if (this.validationBootstrapParameters.constraintValidatorFactory == null) {
            this.validationBootstrapParameters.constraintValidatorFactory = xmlParameters.constraintValidatorFactory != null ? xmlParameters.constraintValidatorFactory : this.defaultConstraintValidatorFactory;
        }
        this.validationBootstrapParameters.mappings.addAll(xmlParameters.mappings);
        this.configurationStreams.addAll(xmlParameters.mappings);
        for (Map.Entry<String, String> entry : xmlParameters.configProperties.entrySet()) {
            if (this.validationBootstrapParameters.configProperties.get(entry.getKey()) != null) continue;
            this.validationBootstrapParameters.configProperties.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

