/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.location;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class BeanConstraintLocation
implements ConstraintLocation {
    private final Member member;
    private final Class<?> beanClass;
    private final ElementType elementType;

    public BeanConstraintLocation(Class<?> beanClass) {
        this(beanClass, null);
    }

    public BeanConstraintLocation(Member member) {
        this(member.getDeclaringClass(), member);
    }

    public BeanConstraintLocation(Class<?> beanClass, Member member) {
        this.member = member;
        this.elementType = this.member != null ? (member instanceof Method ? ElementType.METHOD : ElementType.FIELD) : ElementType.TYPE;
        this.beanClass = beanClass;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Type typeOfAnnotatedElement() {
        Type t;
        if (this.member == null) {
            t = this.beanClass;
        } else {
            t = ReflectionHelper.typeOf(this.member);
            if (t instanceof Class && ((Class)t).isPrimitive()) {
                t = ReflectionHelper.boxedType((Class)t);
            }
        }
        return t;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanConstraintLocation that = (BeanConstraintLocation)o;
        if (this.beanClass != null ? !this.beanClass.equals(that.beanClass) : that.beanClass != null) {
            return false;
        }
        return !(this.member != null ? !this.member.equals(that.member) : that.member != null);
    }

    public int hashCode() {
        int result = this.member != null ? this.member.hashCode() : 0;
        result = 31 * result + (this.beanClass != null ? this.beanClass.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BeanConstraintLocation [" + this.beanClass.getSimpleName() + "#" + ReflectionHelper.getPropertyName(this.member) + " (" + (Object)((Object)this.elementType) + ")]";
    }
}

