/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Path;
import javax.validation.metadata.ElementDescriptor;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

public final class PathImpl
implements Path,
Serializable {
    private static final long serialVersionUID = 7564511574909882392L;
    private static final Log log = LoggerFactory.make();
    public static final String PROPERTY_PATH_SEPARATOR = ".";
    public static final String RETURN_VALUE_NODE_NAME = "$retval";
    private static final String LEADING_PROPERTY_GROUP = "[^\\[\\.]+";
    private static final String OPTIONAL_INDEX_GROUP = "\\[(\\w*)\\]";
    private static final String REMAINING_PROPERTY_STRING = "\\.(.*)";
    private static final Pattern PATH_PATTERN = Pattern.compile("([^\\[\\.]+)(\\[(\\w*)\\])?(\\.(.*))*");
    private static final int PROPERTY_NAME_GROUP = 1;
    private static final int INDEXED_GROUP = 2;
    private static final int INDEX_GROUP = 3;
    private static final int REMAINING_STRING_GROUP = 5;
    private final List<Path.Node> nodeList;
    private NodeImpl currentLeafNode;
    private int hashCode;

    public static PathImpl createPathFromString(String propertyPath) {
        Contracts.assertNotNull(propertyPath, Messages.MESSAGES.propertyPathCannotBeNull());
        if (propertyPath.length() == 0) {
            return PathImpl.createNewPath(null);
        }
        return PathImpl.parseProperty(propertyPath);
    }

    public static PathImpl createPathForParameter(ExecutableElement executable, String parameterName) {
        Contracts.assertNotNull(executable, "A method is required to create a method parameter path.");
        Contracts.assertNotNull(parameterName, "A parameter name is required to create a method parameter path.");
        PathImpl path = PathImpl.createRootPath();
        path.addParameterNode(executable, parameterName);
        return path;
    }

    public static PathImpl createPathForMethodReturnValue(ExecutableElement executable) {
        Contracts.assertNotNull(executable, "A method is required to create a method return value path.");
        PathImpl path = PathImpl.createRootPath();
        path.addReturnValueNode(executable);
        return path;
    }

    public static PathImpl createRootPath() {
        return PathImpl.createNewPath(null);
    }

    public static PathImpl createCopy(PathImpl path) {
        return new PathImpl(path);
    }

    public static PathImpl createCopyWithElementDescriptorsAttached(PathImpl path, List<ElementDescriptor> elementDescriptors) {
        return new PathImpl(path, elementDescriptors);
    }

    public final boolean isRootPath() {
        return this.nodeList.size() == 1 && this.nodeList.get(0).getName() == null;
    }

    public final PathImpl getPathWithoutLeafNode() {
        return new PathImpl(this.nodeList.subList(0, this.nodeList.size() - 1));
    }

    public final NodeImpl addNode(String nodeName) {
        NodeImpl parent = this.nodeList.isEmpty() ? null : (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
        this.currentLeafNode = new NodeImpl(nodeName, parent, false, null, null);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    private NodeImpl addParameterNode(ExecutableElement executable, String parameterName) {
        NodeImpl parent = this.nodeList.isEmpty() ? null : (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
        String executableName = executable.getMember().getDeclaringClass().getSimpleName() + "#" + executable.getSimpleName();
        this.nodeList.add(new NodeImpl(executableName, parent, false, null, null));
        this.currentLeafNode = new NodeImpl(parameterName, parent, false, null, null);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    private NodeImpl addReturnValueNode(ExecutableElement executable) {
        NodeImpl parent = this.nodeList.isEmpty() ? null : (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
        String executableName = executable.getMember().getDeclaringClass().getSimpleName() + "#" + executable.getSimpleName();
        this.nodeList.add(new NodeImpl(executableName, parent, false, null, null));
        this.currentLeafNode = new NodeImpl(RETURN_VALUE_NODE_NAME, parent, false, null, null);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl makeLeafNodeIterable() {
        this.currentLeafNode = new NodeImpl(this.currentLeafNode.getName(), this.currentLeafNode.getParent(), true, null, null);
        this.nodeList.remove(this.nodeList.size() - 1);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl setLeafNodeIndex(Integer index) {
        this.currentLeafNode = new NodeImpl(this.currentLeafNode.getName(), this.currentLeafNode.getParent(), true, index, null);
        this.nodeList.remove(this.nodeList.size() - 1);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl setLeafNodeMapKey(Object key) {
        this.currentLeafNode = new NodeImpl(this.currentLeafNode.getName(), this.currentLeafNode.getParent(), true, null, key);
        this.nodeList.remove(this.nodeList.size() - 1);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl getLeafNode() {
        return this.currentLeafNode;
    }

    @Override
    public final Iterator<Path.Node> iterator() {
        if (this.nodeList.size() == 0) {
            return Collections.emptyList().iterator();
        }
        if (this.nodeList.size() == 1) {
            return this.nodeList.iterator();
        }
        return this.nodeList.subList(1, this.nodeList.size()).iterator();
    }

    public final String asString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (int i = 1; i < this.nodeList.size(); ++i) {
            NodeImpl nodeImpl = (NodeImpl)this.nodeList.get(i);
            if (nodeImpl.getName() != null) {
                if (!first) {
                    builder.append(PROPERTY_PATH_SEPARATOR);
                }
                builder.append(nodeImpl.asString());
            }
            first = false;
        }
        return builder.toString();
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathImpl other = (PathImpl)obj;
        return !(this.nodeList == null ? other.nodeList != null : !((Object)this.nodeList).equals(other.nodeList));
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.buildHashCode();
        }
        return this.hashCode;
    }

    private int buildHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeList == null ? 0 : ((Object)this.nodeList).hashCode());
        return result;
    }

    private static PathImpl createNewPath(String name) {
        PathImpl path = new PathImpl();
        path.addNode(name);
        return path;
    }

    private PathImpl(PathImpl path) {
        this(path.nodeList);
        this.currentLeafNode = (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
    }

    private PathImpl(PathImpl path, List<ElementDescriptor> elementDescriptors) {
        this();
        NodeImpl parent = this.addNode(null);
        int i = 0;
        for (Path.Node node : path) {
            NodeImpl oldNode = (NodeImpl)node;
            NodeImpl newNode = new NodeImpl(oldNode, parent, elementDescriptors.get(i));
            this.nodeList.add(newNode);
            parent = newNode;
            ++i;
        }
    }

    private PathImpl() {
        this.nodeList = new ArrayList<Path.Node>();
    }

    private PathImpl(List<Path.Node> nodeList) {
        this.nodeList = new ArrayList<Path.Node>(nodeList);
    }

    private static PathImpl parseProperty(String property) {
        PathImpl path = PathImpl.createNewPath(null);
        String tmp = property;
        do {
            Matcher matcher;
            if ((matcher = PATH_PATTERN.matcher(tmp)).matches()) {
                String indexOrKey;
                String value = matcher.group(1);
                if (!PathImpl.isValidJavaIdentifier(value)) {
                    throw log.getInvalidJavaIdentifierException(value);
                }
                path.addNode(value);
                if (matcher.group(2) != null) {
                    path.makeLeafNodeIterable();
                }
                if ((indexOrKey = matcher.group(3)) != null && indexOrKey.length() > 0) {
                    try {
                        Integer i = Integer.parseInt(indexOrKey);
                        path.setLeafNodeIndex(i);
                    }
                    catch (NumberFormatException e) {
                        path.setLeafNodeMapKey(indexOrKey);
                    }
                }
            } else {
                throw log.getUnableToParsePropertyPathException(property);
            }
            tmp = matcher.group(5);
        } while (tmp != null);
        if (path.getLeafNode().isIterable()) {
            path.addNode(null);
        }
        return path;
    }

    private static boolean isValidJavaIdentifier(String identifier) {
        Contracts.assertNotNull(identifier, "identifier param cannot be null");
        if (identifier.length() == 0 || !Character.isJavaIdentifierStart((int)identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (Character.isJavaIdentifierPart((int)identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

