/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstrainedMethod
extends AbstractConstrainedElement {
    private static final Log log = LoggerFactory.make();
    private final List<ConstrainedParameter> parameterMetaData;
    private final boolean hasParameterConstraints;

    public ConstrainedMethod(ConfigurationSource source, MethodConstraintLocation location, Set<MetaConstraint<?>> returnValueConstraints, boolean isCascading) {
        this(source, location, Collections.emptyList(), returnValueConstraints, isCascading);
    }

    public ConstrainedMethod(ConfigurationSource source, MethodConstraintLocation location, List<ConstrainedParameter> parameterMetaData, Set<MetaConstraint<?>> returnValueConstraints, boolean isCascading) {
        super(source, location.getElementType() == ElementType.CONSTRUCTOR ? ConstrainedElement.ConstrainedElementKind.CONSTRUCTOR : ConstrainedElement.ConstrainedElementKind.METHOD, location, returnValueConstraints, isCascading);
        ExecutableElement method = location.getExecutableElement();
        if (parameterMetaData.size() != method.getParameterTypes().length) {
            throw log.getInvalidLengthOfParameterMetaDataListException(method, method.getParameterTypes().length, parameterMetaData.size());
        }
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        this.hasParameterConstraints = this.hasParameterConstraints(parameterMetaData);
        if (this.isConstrained()) {
            ReflectionHelper.setAccessibility(method.getMember());
        }
    }

    private boolean hasParameterConstraints(List<ConstrainedParameter> parameterMetaData) {
        for (ConstrainedParameter oneParameter : parameterMetaData) {
            if (!oneParameter.isConstrained()) continue;
            return true;
        }
        return false;
    }

    @Override
    public MethodConstraintLocation getLocation() {
        return (MethodConstraintLocation)super.getLocation();
    }

    public ConstrainedParameter getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaData.size() - 1) {
            throw log.getInvalidMethodParameterIndexException(this.getLocation().getMember().getName(), parameterIndex);
        }
        return this.parameterMetaData.get(parameterIndex);
    }

    public List<ConstrainedParameter> getAllParameterMetaData() {
        return this.parameterMetaData;
    }

    @Override
    public boolean isConstrained() {
        return super.isConstrained() || this.hasParameterConstraints;
    }

    public boolean hasParameterConstraints() {
        return this.hasParameterConstraints;
    }

    public boolean isGetterMethod() {
        return this.getLocation().getExecutableElement().isGetterMethod();
    }

    @Override
    public String toString() {
        return "ConstrainedMethod [location=" + this.getLocation() + ", parameterMetaData=" + this.parameterMetaData + ", hasParameterConstraints=" + this.hasParameterConstraints + "]";
    }
}

