/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.util.List;
import java.util.Set;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ParameterDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ParameterMetaData
extends AbstractConstraintMetaData {
    private final int index;

    private ParameterMetaData(int index, String name, Class<?> type, Set<MetaConstraint<?>> constraints, boolean isCascading) {
        super(name, type, constraints, ConstraintMetaData.ConstraintMetaDataKind.PARAMETER, isCascading, !constraints.isEmpty() || isCascading);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public ParameterDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ParameterDescriptorImpl(this.getType(), this.index, this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    public static class Builder
    extends MetaDataBuilder {
        private final Class<?> rootClass;
        private final Class<?> parameterType;
        private final int parameterIndex;
        private final Set<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        private String name;
        private boolean isCascading = false;

        public Builder(Class<?> rootClass, ConstrainedParameter constrainedParameter, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.rootClass = rootClass;
            this.parameterType = constrainedParameter.getLocation().getParameterType();
            this.parameterIndex = constrainedParameter.getLocation().getParameterIndex();
            this.add(constrainedParameter);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (constrainedElement.getKind() != ConstrainedElement.ConstrainedElementKind.PARAMETER) {
                return false;
            }
            return ((ConstrainedParameter)constrainedElement).getLocation().getParameterIndex() == this.parameterIndex;
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            ConstrainedParameter constrainedParameter = (ConstrainedParameter)constrainedElement;
            this.constraints.addAll(constrainedParameter.getConstraints());
            if (this.name == null) {
                this.name = constrainedParameter.getParameterName();
            }
            this.isCascading = this.isCascading || constrainedParameter.isCascading();
        }

        @Override
        public ParameterMetaData build() {
            return new ParameterMetaData(this.parameterIndex, this.name, this.parameterType, this.adaptOriginsAndImplicitGroups(this.rootClass, this.constraints), this.isCascading);
        }
    }
}

