/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;

public class ValidatorContextImpl
implements HibernateValidatorContext {
    private final MessageInterpolator factoryMessageInterpolator;
    private final TraversableResolver factoryTraversableResolver;
    private final ConstraintValidatorFactory factoryConstraintValidatorFactory;
    private final ParameterNameProvider factoryParameterNameProvider;
    private final BeanMetaDataManager beanMetaDataManager;
    private final ConstraintValidatorManager constraintValidatorManager;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private ParameterNameProvider parameterNameProvider;
    private boolean failFast;

    public ValidatorContextImpl(MessageInterpolator factoryMessageInterpolator, TraversableResolver factoryTraversableResolver, ParameterNameProvider factoryParameterNameProvider, BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, boolean failFast) {
        this.factoryConstraintValidatorFactory = constraintValidatorManager.getDefaultConstraintValidatorFactory();
        this.factoryMessageInterpolator = factoryMessageInterpolator;
        this.factoryTraversableResolver = factoryTraversableResolver;
        this.factoryParameterNameProvider = factoryParameterNameProvider;
        this.beanMetaDataManager = beanMetaDataManager;
        this.constraintValidatorManager = constraintValidatorManager;
        this.failFast = failFast;
        this.messageInterpolator(factoryMessageInterpolator);
        this.traversableResolver(factoryTraversableResolver);
        this.constraintValidatorFactory(this.factoryConstraintValidatorFactory);
    }

    @Override
    public HibernateValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator == null ? this.factoryMessageInterpolator : messageInterpolator;
        return this;
    }

    @Override
    public HibernateValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver == null ? this.factoryTraversableResolver : traversableResolver;
        return this;
    }

    @Override
    public HibernateValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        this.constraintValidatorFactory = factory == null ? this.factoryConstraintValidatorFactory : factory;
        return this;
    }

    @Override
    public HibernateValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider == null ? this.factoryParameterNameProvider : parameterNameProvider;
        return this;
    }

    @Override
    public HibernateValidatorContext failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public Validator getValidator() {
        return new ValidatorImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.beanMetaDataManager, this.constraintValidatorManager, this.failFast);
    }
}

