/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.location;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class MethodConstraintLocation
implements ConstraintLocation {
    private final ExecutableElement executableElement;
    private final Integer parameterIndex;

    public MethodConstraintLocation(Method method) {
        this(ExecutableElement.forMethod(method), null);
    }

    public MethodConstraintLocation(Method method, Integer parameterIndex) {
        this(ExecutableElement.forMethod(method), parameterIndex);
    }

    public MethodConstraintLocation(ExecutableElement executableElement, Integer parameterIndex) {
        Contracts.assertValueNotNull(executableElement, "executableElement");
        this.executableElement = executableElement;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.executableElement.getMember().getDeclaringClass();
    }

    @Override
    public Type typeOfAnnotatedElement() {
        Type t = this.parameterIndex == null ? ReflectionHelper.typeOf(this.executableElement.getMember()) : ReflectionHelper.typeOf(this.executableElement, this.parameterIndex);
        if (t instanceof Class && ((Class)t).isPrimitive()) {
            t = ReflectionHelper.boxedType(t);
        }
        return t;
    }

    @Override
    public Member getMember() {
        return this.executableElement.getMember();
    }

    public ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    @Override
    public ElementType getElementType() {
        return this.parameterIndex != null ? ElementType.PARAMETER : this.executableElement.getElementType();
    }

    public Integer getParameterIndex() {
        return this.parameterIndex;
    }

    public Class<?> getParameterType() {
        return this.parameterIndex != null ? this.executableElement.getParameterTypes()[this.parameterIndex] : null;
    }

    public String toString() {
        return String.format("%s#%s(%s)", this.executableElement.getMember().getDeclaringClass().getSimpleName(), this.executableElement.getMember().getName(), this.parameterIndex != null ? this.parameterIndex : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.executableElement == null ? 0 : this.executableElement.hashCode());
        result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodConstraintLocation other = (MethodConstraintLocation)obj;
        if (this.executableElement == null ? other.executableElement != null : !this.executableElement.equals(other.executableElement)) {
            return false;
        }
        return !(this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex));
    }
}

