/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.Cascadable;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.GroupConverter;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ParameterDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;

public class ParameterMetaData
extends AbstractConstraintMetaData
implements Cascadable {
    private final GroupConverter groupConverter;
    private final int index;

    private ParameterMetaData(int index, String name, Class<?> type, Set<MetaConstraint<?>> constraints, boolean isCascading, Map<Class<?>, Class<?>> groupConversions) {
        super(name, type, constraints, ConstraintMetaData.ConstraintMetaDataKind.PARAMETER, isCascading, !constraints.isEmpty() || isCascading);
        this.groupConverter = new GroupConverter(groupConversions);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConverter.convertGroup(originalGroup);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.PARAMETER;
    }

    @Override
    public Object getValue(Object parent) {
        return ((Object[])parent)[this.index];
    }

    @Override
    public ParameterDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ParameterDescriptorImpl(this.getType(), this.index, this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    public static class Builder
    extends MetaDataBuilder {
        private final Class<?> rootClass;
        private final Class<?> parameterType;
        private final int parameterIndex;
        private String name;

        public Builder(Class<?> rootClass, ConstrainedParameter constrainedParameter, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.rootClass = rootClass;
            this.parameterType = constrainedParameter.getLocation().getParameterType();
            this.parameterIndex = constrainedParameter.getLocation().getParameterIndex();
            this.add(constrainedParameter);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (constrainedElement.getKind() != ConstrainedElement.ConstrainedElementKind.PARAMETER) {
                return false;
            }
            return ((ConstrainedParameter)constrainedElement).getLocation().getParameterIndex() == this.parameterIndex;
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            ConstrainedParameter constrainedParameter = (ConstrainedParameter)constrainedElement;
            if (this.name == null) {
                this.name = constrainedParameter.getParameterName();
            }
        }

        @Override
        public ParameterMetaData build() {
            return new ParameterMetaData(this.parameterIndex, this.name, this.parameterType, this.adaptOriginsAndImplicitGroups(this.rootClass, this.getConstraints()), this.isCascading(), this.getGroupConversions());
        }
    }
}

