/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.spi.MethodValidated;
import org.hibernate.validator.cdi.HibernateValidator;
import org.hibernate.validator.internal.cdi.ValidatorBean;
import org.hibernate.validator.internal.cdi.ValidatorFactoryBean;
import org.hibernate.validator.internal.cdi.interceptor.ValidationEnabledAnnotatedType;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.util.Contracts;

public class ValidationExtension
implements Extension {
    private final ConstraintHelper constraintHelper = new ConstraintHelper();

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(afterBeanDiscoveryEvent, "The AfterBeanDiscovery event cannot be null");
        Contracts.assertNotNull(beanManager, "The BeanManager cannot be null");
        this.addValidatorFactoryIfRequired(afterBeanDiscoveryEvent, beanManager);
        this.addValidatorIfRequired(afterBeanDiscoveryEvent, beanManager);
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(beforeBeanDiscoveryEvent, "The BeforeBeanDiscovery event cannot be null");
        beforeBeanDiscoveryEvent.addInterceptorBinding(MethodValidated.class, new Annotation[0]);
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        Contracts.assertNotNull(processAnnotatedTypeEvent, "The ProcessAnnotatedType event cannot be null");
        AnnotatedType type = processAnnotatedTypeEvent.getAnnotatedType();
        Set<AnnotatedCallable<T>> constrainedCallables = this.determineConstrainedCallables(type);
        if (!constrainedCallables.isEmpty()) {
            ValidationEnabledAnnotatedType<T> wrappedType = new ValidationEnabledAnnotatedType<T>(type, constrainedCallables);
            processAnnotatedTypeEvent.setAnnotatedType(wrappedType);
        }
    }

    private <T> Set<AnnotatedCallable<T>> determineConstrainedCallables(AnnotatedType<T> type) {
        HashSet<AnnotatedCallable<T>> callables = new HashSet<AnnotatedCallable<T>>();
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (!this.isCallableConstrained((AnnotatedCallable<? super T>)constructor)) continue;
            callables.add((AnnotatedCallable<T>)constructor);
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (!this.isCallableConstrained((AnnotatedCallable<? super T>)method)) continue;
            callables.add((AnnotatedCallable<T>)method);
        }
        return callables;
    }

    private <T> boolean isCallableConstrained(AnnotatedCallable<? super T> callable) {
        if (this.containsConstraintAnnotation(callable.getAnnotations())) {
            return true;
        }
        for (AnnotatedParameter parameter : callable.getParameters()) {
            if (!this.containsConstraintAnnotation(parameter.getAnnotations())) continue;
            return true;
        }
        return false;
    }

    private boolean containsConstraintAnnotation(Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!this.constraintHelper.isConstraintAnnotation(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private void addValidatorFactoryIfRequired(AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        Set<Annotation> missingQualifiers = this.determineMissingQualifiers(beanManager, ValidatorFactory.class);
        if (missingQualifiers.isEmpty()) {
            return;
        }
        afterBeanDiscovery.addBean((Bean)new ValidatorFactoryBean(beanManager, missingQualifiers));
    }

    private void addValidatorIfRequired(AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        Set<Annotation> missingQualifiers = this.determineMissingQualifiers(beanManager, Validator.class);
        if (missingQualifiers.isEmpty()) {
            return;
        }
        afterBeanDiscovery.addBean((Bean)new ValidatorBean(beanManager, missingQualifiers));
    }

    private Set<Annotation> determineMissingQualifiers(BeanManager beanManager, Class<?> clazz) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(2);
        Set beans = beanManager.getBeans(clazz, new Annotation[0]);
        boolean containsDefaultQualifier = false;
        boolean containsHibernateQualifier = false;
        for (Bean bean : beans) {
            for (Annotation annotation : bean.getQualifiers()) {
                if (HibernateValidator.class.equals(annotation.annotationType())) {
                    containsHibernateQualifier = true;
                }
                if (!Default.class.equals(annotation.annotationType())) continue;
                containsDefaultQualifier = true;
            }
        }
        if (!containsDefaultQualifier) {
            annotations.add((Annotation)new AnnotationLiteral<Default>(){});
        }
        if (!containsHibernateQualifier) {
            annotations.add((Annotation)new AnnotationLiteral<HibernateValidator>(){});
        }
        return annotations;
    }
}

