/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.Validator;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.spi.MethodValidated;

@MethodValidated
@Interceptor
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = 604440259030722151L;
    @Inject
    private Validator validator;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        Set<ConstraintViolation<Object>> violations = this.validator.forMethods().validateParameters(ctx.getTarget(), ctx.getMethod(), ctx.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        Object result = ctx.proceed();
        violations = this.validator.forMethods().validateReturnValue(ctx.getTarget(), ctx.getMethod(), result, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        return result;
    }

    private String getMessage(Method method, Object[] args, Set<? extends ConstraintViolation<?>> violations) {
        StringBuilder message = new StringBuilder();
        message.append(violations.size());
        message.append(" constraint violation(s) occurred during method invocation.");
        message.append("\nMethod: ");
        message.append(method);
        message.append("\nArgument values: ");
        message.append(Arrays.toString(args));
        message.append("\nConstraint violations: ");
        int i = 1;
        for (ConstraintViolation<?> constraintViolation : violations) {
            ElementDescriptor elementDescriptor = this.locateElementDescriptor(constraintViolation);
            message.append("\n (");
            message.append(i);
            message.append(")");
            if (elementDescriptor != null) {
                message.append(" Kind: ");
                message.append((Object)elementDescriptor.getKind());
                if (elementDescriptor instanceof ParameterDescriptor) {
                    message.append("\n parameter index: ");
                    message.append(((ParameterDescriptor)elementDescriptor).getIndex());
                }
            }
            message.append("\n message: ");
            message.append(constraintViolation.getMessage());
            message.append("\n root bean: ");
            message.append(constraintViolation.getRootBean());
            message.append("\n property path: ");
            message.append(constraintViolation.getPropertyPath());
            message.append("\n constraint: ");
            message.append(constraintViolation.getConstraintDescriptor().getAnnotation());
            ++i;
        }
        return message.toString();
    }

    private ElementDescriptor locateElementDescriptor(ConstraintViolation<?> constraintViolation) {
        Iterator nodes = constraintViolation.getPropertyPath().iterator();
        Path.Node leafNode = null;
        while (nodes.hasNext()) {
            leafNode = (Path.Node)nodes.next();
        }
        return leafNode == null ? null : leafNode.getElementDescriptor();
    }
}

