/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import java.util.ArrayList;
import java.util.Iterator;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.path.BeanMetaDataLocator;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.PropertyMetaData;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class BeanMetaDataLocatorClassTraversal
extends BeanMetaDataLocator {
    private final Class<?> rootBeanClass;
    private final BeanMetaDataManager beanMetaDataManager;

    BeanMetaDataLocatorClassTraversal(Class<?> rootBeanClass, BeanMetaDataManager beanMetaDataManager) {
        this.rootBeanClass = rootBeanClass;
        this.beanMetaDataManager = beanMetaDataManager;
    }

    @Override
    public Iterator<BeanMetaData<?>> beanMetaDataIterator(Iterator<Path.Node> nodeIterator) {
        Contracts.assertNotNull(nodeIterator);
        ArrayList metaDataList = new ArrayList();
        Class currentClass = this.rootBeanClass;
        while (nodeIterator.hasNext()) {
            Path.Node node = nodeIterator.next();
            BeanMetaData<?> beanMetaData = this.beanMetaDataManager.getBeanMetaData(currentClass);
            metaDataList.add(beanMetaData);
            PropertyMetaData property = beanMetaData.getMetaDataFor(node.getName());
            if (property == null || !property.isCascading() || !ReflectionHelper.isIterable(currentClass = property.getRawType())) continue;
            currentClass = (Class)ReflectionHelper.getIndexedType(currentClass);
        }
        return metaDataList.iterator();
    }
}

